% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{kaya_data}
\alias{kaya_data}
\title{Kaya identity data for many countries}
\format{A tibble containing 13163 rows and 13 variables:
\describe{
  \item{region}{Country or region name}
  \item{region_code}{Three-letter country or region code}
  \item{geography}{Geographic category: "nation", "region", or "world"}
  \item{year}{The year}
  \item{P}{Population, in billions}
  \item{G}{Gross domestic product, in trillions of constant 2010 U.S. dollars.}
  \item{E}{Total primary energy consumption, in quads}
  \item{F}{CO2 emissions from fossil fuel consumption, in millions of tons}
  \item{g}{Per-capita GDP, in thousands of constant 2010 U.S. dollars per person.}
  \item{e}{Energy intensity of the economy, in quads per trillion dollars.}
  \item{f}{Emissions intensity of the energy supply, in million metric tons
           per quad.}
  \item{ef}{Emissions intensity of the economy, in metric tons per
            million dollars of GDP.}
  \item{G_ppp}{Gross domestic product adjusted for purchasing power parity,
               in trillions of constant 2011 international dollars}
  \item{G_mer}{Gross domestic product at market-exchange-rate,
               in trillions of constant 2010 U.S. dollars}
}}
\source{
\url{https://data.worldbank.org/indicator/SP.POP.TOTL},
\url{https://data.worldbank.org/indicator/NY.GDP.MKTP.KD}, and
\url{https://www.bp.com/en/global/corporate/energy-economics/statistical-review-of-world-energy/downloads.html}
}
\usage{
kaya_data
}
\description{
A dataset containing Kaya identity parameters
P, G, E, F, g, e, f, and ef for many countries
}
\keyword{datasets}
