% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/seriate_refine.R
\docType{methods}
\name{seriate_refine}
\alias{seriate_refine}
\alias{seriate_refine-method}
\alias{seriate_refine,AveragePermutationOrder-method}
\alias{seriate_refine,BootstrapCA-method}
\title{Refine CA-based Seriation}
\usage{
seriate_refine(object, ...)

\S4method{seriate_refine}{AveragePermutationOrder}(object, cutoff, margin = 1, axes = 1, n = 30, ...)

\S4method{seriate_refine}{BootstrapCA}(object, cutoff, margin = 1, axes = 1, ...)
}
\arguments{
\item{object}{A \code{\linkS4class{PermutationOrder}} object (typically returned by
\code{\link[=seriate_average]{seriate_average()}}).}

\item{...}{Further arguments to be passed to internal methods.}

\item{cutoff}{A function that takes a numeric vector as argument and returns
a single numeric value (see below).}

\item{margin}{A length-one \code{\link{numeric}} vector giving the subscripts which the
refinement will be applied over: \code{1} indicates rows, \code{2} indicates columns.}

\item{axes}{An \code{\link{integer}} vector giving the subscripts of the CA axes to be
used.}

\item{n}{A non-negative \code{\link{integer}} giving the number of bootstrap
replications.}
}
\value{
A \code{\linkS4class{RefinePermutationOrder}} object.
}
\description{
Refine CA-based Seriation
}
\details{
\code{seriate_refine()} allows to identify samples that are subject to
sampling error or samples that have underlying structural relationships
and might be influencing the ordering along the CA space.

This relies on a partial bootstrap approach to CA-based seriation where each
sample is replicated \code{n} times. The maximum dimension length of
the convex hull around the sample point cloud allows to remove samples for
a given \code{cutoff} value.

According to Peebles and Schachner (2012), "[this] point removal procedure
[results in] a reduced dataset where the position of individuals within
the CA are highly stable and which produces an ordering consistent with the
assumptions of frequency seriation."
}
\references{
Peeples, M. A., & Schachner, G. (2012). Refining correspondence
analysis-based ceramic seriation of regional data sets. \emph{Journal of
Archaeological Science}, 39(8), 2818-2827.
\doi{10.1016/j.jas.2012.04.040}.
}
\seealso{
Other seriation methods: 
\code{\link{permute}()},
\code{\link{seriate_average}()},
\code{\link{seriate_rank}()}
}
\author{
N. Frerebeau
}
\concept{seriation methods}
