% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics_helpers.R
\name{listify_args}
\alias{listify_args}
\title{Convert arguments for a single call into Map-able args}
\usage{
listify_args(
  ...,
  lengths = NA,
  passthru = c("x", "y"),
  notlen1vec = c("lim", "xlim", "ylim"),
  notlen1lst = c("minmax", "min", "max"),
  ignore = c("same_lim")
)
}
\arguments{
\item{...}{Arbitrary arguments to be possibly converted into lists
of arguments.}

\item{lengths}{Allowable lengths of the arguments, typically 1 and
the length of the main variable (e.g., "x"). If 'NA' (default),
it is not enforced.}

\item{passthru}{Character vector of variables to pass through with
no conversion to lists of values. Extra names (not provided in
\code{...}) are ignored.}

\item{notlen1vec}{Character vector of variables that are known to
be length over 1 for a single plot call, so it will always be
list-ified and extra care to ensure it is grouped correctly.
Extra names (not provided in \code{...}) are ignored.}

\item{notlen1lst}{Character vector of variables that are lists, so
the inner list length is not checked/enforced. (For example, if a
single plot call takes an argument \code{list(a=1,b=2,d=3)} and the
multi-data call creates three plots, then a naive match might
think that the first plot would get \code{list(a=1)}, second plot gets
\code{list(b=2)}, etc. Adding that list-argument to this 'notlen1lst'
will ensure that the full list is passed correctly.) Extra names
(not provided in \code{...}) are ignored.}

\item{ignore}{Character vector of variables to ignore, never
returned. (Generally one can control this by not adding the
variable in the first place, but having this here allows some
sanity checks and/or programmatic usage.)}
}
\value{
list, generally a list of embedded lists
}
\description{
Convert arguments for a single call into Map-able args
}
