% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_rows.R
\name{group_rows}
\alias{group_rows}
\title{Put a few rows of a table into one category}
\usage{
group_rows(kable_input, group_label = NULL, start_row = NULL,
  end_row = NULL, index = NULL,
  label_row_css = "border-bottom: 1px solid;", latex_gap_space = "0.3em",
  escape = TRUE)
}
\arguments{
\item{kable_input}{Output of \code{knitr::kable()} with \code{format} specified}

\item{group_label}{A character string for the name of the group}

\item{start_row}{A numeric value that tells the function in which row the
group starts. Note that the counting excludes header rows and other group
labeling rows}

\item{end_row}{A numeric value that tells the function in which row the group
ends.}

\item{index}{A named vector providing the index for robust row-grouping tasks.
Basically, you can use it in the same way as \code{add_header_above()}.}

\item{label_row_css}{A character string for any customized css used for the
labeling row. By default, the labeling row will have a solid black line
underneath. Only useful for HTML documents.}

\item{latex_gap_space}{A character value telling LaTeX how large the gap
between the previous row and the group labeling row. Only useful for LaTeX
documents.}

\item{escape}{A T/F value showing whether special characters should be
escaped.}
}
\description{
Group a few rows in a table together under a label.
}
\examples{
x <- knitr::kable(head(mtcars), "html")
# Put Row 2 to Row 5 into a Group and label it as "Group A"
group_rows(x, "Group A", 2, 5)

}
