% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jubilee-read-fred-file.R
\name{jubilee.read_fred_file}
\alias{jubilee.read_fred_file}
\title{Internal utility to read FRED file}
\usage{
jubilee.read_fred_file(fraction, local_file, symbol, online = FALSE,
  daily_symbol = NULL)
}
\arguments{
\item{fraction}{numeric, the fraction to return the value. 
The utility will lookup within a month to find value.
For debug purpose, set it to \code{NULL}, and the intermediate 
data table will be returned.}

\item{local_file}{character, the file name of an internal file.
For debug purpose, set it to \code{NULL}, and the process will
initiate the source data from FRED via \code{symbol}, 
instead of a local file.}

\item{symbol}{character, the FRED symbol.}

\item{online}{logical, whether to fetch online data from FRED. Default is \code{FALSE}.}

\item{daily_symbol}{character, the FRED symbol to read daily data that supplements 
the monthly data. Default is \code{NULL}.}
}
\value{
The values of the symbol, numeric with the same length as \code{fraction}.
}
\description{
This utility reads the internal static file, optionally amends with FRED online data,
and returns the values of a given symbol.
}
\examples{
  repo <- jubilee.repo(online=FALSE)
  a <- jubilee.read_fred_file(repo@ie$fraction, "BAA.csv", "BAA")
  tail(a)

}
\author{
Stephen H. Lihn
}
\keyword{data}
