% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summ_helpers.R
\name{get_robust_se}
\alias{get_robust_se}
\title{Calculate robust standard errors and produce coefficient tables}
\usage{
get_robust_se(model, type = "HC3", cluster = NULL,
  data = model.frame(model))
}
\arguments{
\item{model}{A regression model, preferably of class \code{lm} or \code{glm}}

\item{type}{One of \code{"HC3"}, \code{"const"}, \code{"HC"}, \code{"HC0"}, \code{"HC1"},
\code{"HC2"}, \code{"HC4"}, \code{"HC4m"}, \code{"HC5"}. See \code{\link[sandwich:vcovHC]{sandwich::vcovHC()}} for some
more details on these choices. Note that some of these do not work for
clustered standard errors (see sandwich::vcovCL()]).}

\item{cluster}{If you want clustered standard errors, either a string naming
the column in \code{data} that represents the clusters or a vector of clusters
that is the same length as the number of rows in \code{data}.}

\item{data}{The data used to fit the model. Default is to just get the
\code{model.frame} from \code{model}.}
}
\value{
A list with the following:
\itemize{
\item \code{coefs}: a coefficient table with the estimates, standard errors,
t-statistics, and p-values from \code{lmtest}.
\item \code{ses}: The standard errors from \code{coefs}.
\item \code{ts}: The t-statistics from \code{coefs}.
\item \code{ps}: The p-values from \code{coefs}.
\item \code{type}: The argument to \code{robust}.
\item \code{use_cluster}: \code{TRUE} or \code{FALSE} indicator of whether clusters were used.
\item \code{cluster}: The clusters or name of cluster variable used, if any.
\item \code{vcov}: The robust variance-covariance matrix.
}
}
\description{
This function wraps around several \pkg{sandwich}
and \pkg{lmtest} functions to calculate robust standard errors and returns
them in a useful format.
}
