% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestglm.R
\name{TableSubgroupMultiGLM}
\alias{TableSubgroupMultiGLM}
\title{TableSubgroupMultiGLM: Multiple sub-group analysis table for GLM.}
\usage{
TableSubgroupMultiGLM(
  formula,
  var_subgroups = NULL,
  var_cov = NULL,
  data,
  family = "binomial",
  decimal.estimate = 2,
  decimal.percent = 1,
  decimal.pvalue = 3,
  line = F
)
}
\arguments{
\item{formula}{formula with survival analysis.}

\item{var_subgroups}{Multiple sub-group variables for analysis, Default: NULL}

\item{var_cov}{Variables for additional adjust, Default: NULL}

\item{data}{Data or svydesign in survey package.}

\item{family}{family, "gaussian" or "binomial"}

\item{decimal.estimate}{Decimal for estimate, Default: 2}

\item{decimal.percent}{Decimal for percent, Default: 1}

\item{decimal.pvalue}{Decimal for pvalue, Default: 3}

\item{line}{Include new-line between sub-group variables, Default: F}
}
\value{
Multiple sub-group analysis table.
}
\description{
Multiple sub-group analysis table for GLM.
}
\details{
This result is used to make forestplot.
}
\examples{
library(survival);library(dplyr)
lung \%>\% 
  mutate(status = as.integer(status == 1),
         sex = factor(sex),
         kk = factor(as.integer(pat.karno >= 70)),
         kk1 = factor(as.integer(pat.karno >= 60))) -> lung
TableSubgroupMultiGLM(status ~ sex, var_subgroups = c("kk", "kk1"), 
                      data=lung, line = TRUE, family = "binomial")

## survey design
library(survey)
data.design <- svydesign(id = ~1, data = lung)
TableSubgroupMultiGLM(status ~ sex, var_subgroups = c("kk", "kk1"), 
                      data = data.design, family = "binomial")
}
\seealso{
\code{\link[purrr]{map}}
 \code{\link[dplyr]{bind}}
}
