% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeroc.R
\name{timerocUI}
\alias{timerocUI}
\title{timerocUI: shiny module UI for time-dependent roc analysis}
\usage{
timerocUI(id)
}
\arguments{
\item{id}{id}
}
\value{
Shiny module UI for time-dependent roc analysis
}
\description{
Shiny module UI for time-dependent roc analysis
}
\details{
Shiny module UI for time-dependent roc analysis
}
\examples{
library(shiny);library(DT);library(data.table);library(jstable);library(ggplot2)
library(timeROC);library(survIDINRI)
ui <- fluidPage(
   sidebarLayout(
   sidebarPanel(
     timerocUI("timeroc")
   ),
   mainPanel(
     plotOutput("plot_timeroc"),
     ggplotdownUI("timeroc"),
     DTOutput("table_timeroc")
   )
 )
)

server <- function(input, output, session) {

  data <- reactive(mtcars)
  data.label <- jstable::mk.lev(mtcars)

  out_timeroc <- callModule(timerocModule, "timeroc", data = data, data_label = data.label,
                            data_varStruct = NULL)

  output$plot_timeroc <- renderPlot({
    print(out_timeroc()$plot)
  })

  output$table_timeroc <- renderDT({
    datatable(out_timeroc()$tb, rownames=F, editable = F, extensions= "Buttons",
              caption = "ROC results",
              options = c(jstable::opt.tbreg("roctable"), list(scrollX = TRUE)))
  })
}
}
