% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.R
\name{select}
\alias{select}
\alias{select_}
\title{Select variables}
\usage{
select(.data, ...)

select_(.data, ..., .dots)
}
\arguments{
\item{.data}{input. This can be JSON input, or an object of class
\code{jqr} that has JSON and query params combined, which is passed
from function to function when using the jqr DSL.}

\item{...}{Comma separated list of unquoted variable names}

\item{.dots}{Used to work around non-standard evaluation}

\item{dots}{dots}
}
\description{
Select variables
}
\examples{
'{"foo": 5, "bar": 7}' \%>\% select(a = .foo) \%>\% peek
'{"foo": 5, "bar": 7}' \%>\% select(a = .foo)

# using json dataset, just first element
x <- commits \%>\% index(0)
x \%>\%
   select(message = .commit.message, name = .commit.committer.name)
x \%>\% select(sha = .commit.tree.sha, author = .author.login)

# using json dataset, all elements
x <- index(commits)
x \%>\% select(message = .commit.message, name = .commit.committer.name)
x \%>\% select(sha = .sha, name = .commit.committer.name)

# many JSON inputs
'{"foo": 5, "bar": 7} {"foo": 50, "bar": 7} {"foo": 500, "bar": 7}' \%>\%
  select(hello = .foo)
}
