% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webland.R
\name{webland}
\alias{webland}
\alias{webland_trade}
\alias{webland_city}
\title{Information on real estate transaction prices API}
\usage{
webland_trade(lang = c("ja", "en"))

webland_city(lang = c("ja", "en"))
}
\arguments{
\item{lang}{Language.}
}
\value{
\code{webland_trade()} a \code{webland_trade} object. By creating a query with \code{itemise()} and
applying \code{collect()}, The real estate transaction prices are collected.

\code{webland_city()} a \code{webland_city} object. Obtains a list of target
municipalities in the same way as \code{webland_trade()}.
}
\description{
Collect data from the information on real estate transaction prices API
provided by Japan's Ministry of Land, Infrastructure, Transport and Tourism.
}
\examples{
\dontrun{
# Collect trade data
webland_trade() |>
  itemise(from = "20151",
          to = "20152",
          city_code = "13102") |>
  collect()

# Collect target municipalities
webland_city() |>
  itemise(pref_code = "13") |>
  collect()
}

}
