\name{I.spline}
\alias{I.spline}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ I-Spline function }
\description{ Calculate I-Spline bases (5 bases) suggested in Emura et al. (2015). }
\usage{
I.spline(time, xi1, xi3)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{time}{ a vector of times }
  \item{xi1}{ lower bound of times }
  \item{xi3}{ upper bound of times }
}

\details{
The "time" argument is a vector satisfying the contraints xi1<=time<=xi3. Otherwise, error messages will be produced.
}
\value{
\item{NULL }{I-Spline bases (5 bases) evaluated at "time".}
}
\references{
Emura T, Chen YH (2018). Analysis of Survival Data with Dependent Censoring, 
Copula-Based Approaches, JSS Research Series in Statistics, Springer, Singapore.

Supplementary Material to: Emura T, Nakatochi M, Murotani K, Rondeau V (2015), A joint frailty-copula model between tumour progression and death for meta-analysis,
 Statistical Methods in Medical Research, doi: 10.1177/0962280215604510
}
\author{Takeshi Emura}

\examples{
I.spline(c(1,1.5,2,2.5,3),xi1=1,xi3=3)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ Spline }
\keyword{ I-spline }% __ONLY ONE__ keyword per line
