% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{sourcify}
\alias{sourcify}
\title{Converts basic R object into their source representation}
\usage{
sourcify(object, indent = "")
}
\arguments{
\item{object}{the object to convert to source}

\item{indent}{the level of indentation to use}
}
\value{
a string of the equivalent source code
}
\description{
Converts basic R object into their source representation
}
\examples{

sourcify(NULL)

# 'NULL'

sourcify(c(1,2,3))

# 'c(1,2,3)'

l <- list(a=7)
l[['b']] <- 3
l[['c']] <- list(d=3, e=4)
sourcify(l)

# 'list(
#      a=7,
#      b=3,
#      c=list(
#          d=3,
#          e=4))'

}

