% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anovarm.h.R
\name{anovaRM}
\alias{anovaRM}
\title{Repeated Measures ANOVA}
\usage{
anovaRM(data, rm = list(list(label = "RM Factor 1", levels =
  list("Level 1", "Level 2"))), rmCells = NULL, bs = NULL,
  cov = NULL, effectSize = NULL, depLabel = "Dependent",
  rmTerms = NULL, bsTerms = NULL, ss = "3", spherTests = FALSE,
  spherCorr = list("none"), leveneTest = FALSE, contrasts = NULL,
  postHoc = NULL, postHocCorr = list("tukey"),
  emMeans = list(list()), emmPlots = TRUE, emmTables = FALSE,
  emmWeights = TRUE, ciWidthEmm = 95, emmPlotData = FALSE,
  emmPlotError = "ci")
}
\arguments{
\item{data}{the data as a data frame}

\item{rm}{a list of lists, where each list describes the \code{label} (as a
string) and the \code{levels} (as vector of strings) of a particular
repeated measures factor}

\item{rmCells}{a list of lists, where each list decribes a repeated measure
(as a string) from \code{data} defined as \code{measure} and the particular
combination of levels from \code{rm} that it belongs to (as a vector of
strings) defined as \code{cell}}

\item{bs}{a vector of strings naming the between subjects factors from
\code{data}}

\item{cov}{a vector of strings naming the covariates from \code{data}.
Variables must be numeric}

\item{effectSize}{one or more of \code{'eta'}, \code{'partEta'}, or
\code{'omega'}; use eta², partial eta², and omega² effect sizes,
respectively}

\item{depLabel}{a string (default: 'Dependent') describing the label used
for the dependent variable throughout the analysis}

\item{rmTerms}{a list of character vectors describing the repeated measures
terms to go into the model}

\item{bsTerms}{a list of character vectors describing the between subjects
terms to go into the model}

\item{ss}{\code{'2'} or \code{'3'} (default), the sum of squares to use}

\item{spherTests}{\code{TRUE} or \code{FALSE} (default), perform sphericity
tests}

\item{spherCorr}{one or more of \code{'none'} (default), \code{'GG'}, or
\code{}HF\code{}; use no p-value correction, the Greenhouse-Geisser p-value
correction, and the Huynh-Feldt p-value correction for shericity,
respectively}

\item{leveneTest}{\code{TRUE} or \code{FALSE} (default), test for equality
of variances (i.e., Levene's test)}

\item{contrasts}{in development}

\item{postHoc}{a list of character vectors describing the post-hoc tests
that need to be computed}

\item{postHocCorr}{one or more of \code{'none'}, \code{'tukey'} (default),
\code{'scheffe'}, \code{'bonf'}, or \code{'holm'}; use no, Tukey, Scheffe,
Bonferroni and Holm posthoc corrections, respectively}

\item{emMeans}{a list of lists specifying the variables for which the
estimated marginal means need to be calculate. Supports up to three
variables per term.}

\item{emmPlots}{\code{TRUE} (default) or \code{FALSE}, provide estimated
marginal means plots}

\item{emmTables}{\code{TRUE} or \code{FALSE} (default), provide estimated
marginal means tables}

\item{emmWeights}{\code{TRUE} (default) or \code{FALSE}, weigh each cell
equally or weigh them according to the cell frequency}

\item{ciWidthEmm}{a number between 50 and 99.9 (default: 95) specifying the
confidence interval width for the estimated marginal means}

\item{emmPlotData}{\code{TRUE} or \code{FALSE} (default), plot the data on
top of the marginal means}

\item{emmPlotError}{\code{'none'}, \code{'ci'} (default), or \code{'se'}.
Use no error bars, use confidence intervals, or use standard errors on the
marginal mean plots, respectively}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$rmTable} \tab \tab \tab \tab \tab a table \cr
  \code{results$bsTable} \tab \tab \tab \tab \tab a table \cr
  \code{results$assump$spherTable} \tab \tab \tab \tab \tab a table \cr
  \code{results$assump$leveneTable} \tab \tab \tab \tab \tab a table \cr
  \code{results$contrasts} \tab \tab \tab \tab \tab an array of tables \cr
  \code{results$postHoc} \tab \tab \tab \tab \tab an array of tables \cr
  \code{results$emm} \tab \tab \tab \tab \tab an array of the estimated marginal means plots + tables \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$rmTable$asDF}

\code{as.data.frame(results$rmTable)}
}
\description{
The Repeated Measures ANOVA is used to explore the relationship
between a continuous dependent variable and one or more categorical
explanatory variables, where one or more of the explanatory variables
are 'within subjects' (where multiple measurements are from the same
subject). Additionally, this analysis allows the inclusion of
covariates, allowing for repeated measures ANCOVAs as well.
}
\details{
This analysis requires that the data be in 'wide format', where each
row represents a subject (as opposed to long format, where each
measurement of the dependent variable is represented as a row).

A non-parametric equivalent of the repeated measures ANOVA also exists;
the Friedman test. However, it has the limitation of only being able to
test a single factor.
}
\examples{
\dontrun{

data('bugs', package = 'jmv')

anovaRM(
    data = bugs,
    rm = list(
        list(
            label = 'Frightening',
            levels = c('Low', 'High'))),
    rmCells = list(
        list(
            measure = 'LDLF',
            cell = 'Low'),
        list(
            measure = 'LDHF',
            cell = 'High')),
    rmTerms = list(
        'Frightening'))

#
#  REPEATED MEASURES ANOVA
#
#  Within Subjects Effects
#  -----------------------------------------------------------------------
#                  Sum of Squares    df    Mean Square    F       p
#  -----------------------------------------------------------------------
#    Frightening              126     1         126.11    44.2    < .001
#    Residual                 257    90           2.85
#  -----------------------------------------------------------------------
#    Note. Type 3 Sums of Squares
#
#
#
#  Between Subjects Effects
#  -----------------------------------------------------------------
#                Sum of Squares    df    Mean Square    F    p
#  -----------------------------------------------------------------
#    Residual               954    90           10.6
#  -----------------------------------------------------------------
#    Note. Type 3 Sums of Squares
#
}
}
