
# This file is automatically generated, you probably don't want to edit this

efaOptions <- if (requireNamespace('jmvcore')) R6::R6Class(
    "efaOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            vars = NULL,
            nFactorMethod = "parallel",
            nFactors = 1,
            minEigen = 1,
            extraction = "minres",
            rotation = "oblimin",
            hideLoadings = 0.3,
            sortLoadings = FALSE,
            screePlot = FALSE,
            eigen = FALSE,
            factorCor = FALSE,
            factorSummary = FALSE,
            modelFit = FALSE,
            kmo = FALSE,
            bartlett = FALSE, ...) {

            super$initialize(
                package='jmv',
                name='efa',
                requiresData=TRUE,
                ...)

            private$..vars <- jmvcore::OptionVariables$new(
                "vars",
                vars,
                takeFromDataIfMissing=TRUE,
                suggested=list(
                    "ordinal",
                    "continuous"),
                permitted=list(
                    "numeric"),
                rejectInf=FALSE)
            private$..nFactorMethod <- jmvcore::OptionList$new(
                "nFactorMethod",
                nFactorMethod,
                options=list(
                    "parallel",
                    "eigen",
                    "fixed"),
                default="parallel")
            private$..nFactors <- jmvcore::OptionInteger$new(
                "nFactors",
                nFactors,
                min=1,
                default=1)
            private$..minEigen <- jmvcore::OptionNumber$new(
                "minEigen",
                minEigen,
                default=1)
            private$..extraction <- jmvcore::OptionList$new(
                "extraction",
                extraction,
                options=list(
                    "minres",
                    "ml",
                    "pa"),
                default="minres")
            private$..rotation <- jmvcore::OptionList$new(
                "rotation",
                rotation,
                options=list(
                    "none",
                    "varimax",
                    "quartimax",
                    "promax",
                    "oblimin",
                    "simplimax"),
                default="oblimin")
            private$..hideLoadings <- jmvcore::OptionNumber$new(
                "hideLoadings",
                hideLoadings,
                default=0.3)
            private$..sortLoadings <- jmvcore::OptionBool$new(
                "sortLoadings",
                sortLoadings,
                default=FALSE)
            private$..screePlot <- jmvcore::OptionBool$new(
                "screePlot",
                screePlot,
                default=FALSE)
            private$..eigen <- jmvcore::OptionBool$new(
                "eigen",
                eigen,
                default=FALSE)
            private$..factorCor <- jmvcore::OptionBool$new(
                "factorCor",
                factorCor,
                default=FALSE)
            private$..factorSummary <- jmvcore::OptionBool$new(
                "factorSummary",
                factorSummary,
                default=FALSE)
            private$..modelFit <- jmvcore::OptionBool$new(
                "modelFit",
                modelFit,
                default=FALSE)
            private$..kmo <- jmvcore::OptionBool$new(
                "kmo",
                kmo,
                default=FALSE)
            private$..bartlett <- jmvcore::OptionBool$new(
                "bartlett",
                bartlett,
                default=FALSE)

            self$.addOption(private$..vars)
            self$.addOption(private$..nFactorMethod)
            self$.addOption(private$..nFactors)
            self$.addOption(private$..minEigen)
            self$.addOption(private$..extraction)
            self$.addOption(private$..rotation)
            self$.addOption(private$..hideLoadings)
            self$.addOption(private$..sortLoadings)
            self$.addOption(private$..screePlot)
            self$.addOption(private$..eigen)
            self$.addOption(private$..factorCor)
            self$.addOption(private$..factorSummary)
            self$.addOption(private$..modelFit)
            self$.addOption(private$..kmo)
            self$.addOption(private$..bartlett)
        }),
    active = list(
        vars = function() private$..vars$value,
        nFactorMethod = function() private$..nFactorMethod$value,
        nFactors = function() private$..nFactors$value,
        minEigen = function() private$..minEigen$value,
        extraction = function() private$..extraction$value,
        rotation = function() private$..rotation$value,
        hideLoadings = function() private$..hideLoadings$value,
        sortLoadings = function() private$..sortLoadings$value,
        screePlot = function() private$..screePlot$value,
        eigen = function() private$..eigen$value,
        factorCor = function() private$..factorCor$value,
        factorSummary = function() private$..factorSummary$value,
        modelFit = function() private$..modelFit$value,
        kmo = function() private$..kmo$value,
        bartlett = function() private$..bartlett$value),
    private = list(
        ..vars = NA,
        ..nFactorMethod = NA,
        ..nFactors = NA,
        ..minEigen = NA,
        ..extraction = NA,
        ..rotation = NA,
        ..hideLoadings = NA,
        ..sortLoadings = NA,
        ..screePlot = NA,
        ..eigen = NA,
        ..factorCor = NA,
        ..factorSummary = NA,
        ..modelFit = NA,
        ..kmo = NA,
        ..bartlett = NA)
)

efaResults <- if (requireNamespace('jmvcore')) R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        text = function() private$.items[["text"]]),
    private = list(),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="Exploratory Factor Analysis")
            self$add(jmvcore::Preformatted$new(
                options=options,
                name="text",
                title="Exploratory Factor Analysis",
                clearWith=list(
                    "vars",
                    "nFactorMethod",
                    "nFactors",
                    "hideLoadings",
                    "rotation",
                    "factorMethod")))}))

efaBase <- if (requireNamespace('jmvcore')) R6::R6Class(
    "efaBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'efa',
                version = c(1,0,0),
                options = options,
                results = efaResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = FALSE)
        }))

#' Exploratory Factor Analysis
#'
#' Exploratory Factor Analysis
#'
#' @examples
#' data('iris')
#'
#' efa(iris, vars = c('Sepal.Length', 'Sepal.Width', 'Petal.Length', 'Petal.Width'))
#'
#' #
#' #  EXPLORATORY FACTOR ANALYSIS
#' #
#' #  Factor Loadings
#' #  ------------------------------------------------
#' #                    1        2        Uniqueness
#' #  ------------------------------------------------
#' #    Sepal.Length    0.993                0.10181
#' #    Sepal.Width              0.725       0.42199
#' #    Petal.Length    0.933                0.00483
#' #    Petal.Width     0.897                0.07088
#' #  ------------------------------------------------
#' #    Note. 'oblimin' rotation was used
#' #
#'
#' @param data the data as a data frame
#' @param vars a vector of strings naming the variables of interest in
#'   \code{data}
#' @param nFactorMethod \code{'parallel'} (default), \code{'eigen'} or
#'   \code{'fixed'}, the way to determine the number of factors
#' @param nFactors an integer (default: 1), the number of factors in the model
#' @param minEigen a number (default: 1), the minimal eigenvalue for a factor
#'   to be included in the model
#' @param extraction \code{'minres'} (default), \code{'ml'}, or \code{'pa'}
#'   use respectively 'minimum residual', 'maximum likelihood', or 'prinicipal
#'   axis' as the factor extraction method
#' @param rotation \code{'none'}, \code{'varimax'}, \code{'quartimax'},
#'   \code{'promax'}, \code{'oblimin'} (default), or \code{'simplimax'}, the
#'   rotation to use in estimation
#' @param hideLoadings a number (default: 0.3), hide factor loadings below
#'   this value
#' @param sortLoadings \code{TRUE} or \code{FALSE} (default), sort the factor
#'   loadings by size
#' @param screePlot \code{TRUE} or \code{FALSE} (default), show scree plot
#' @param eigen \code{TRUE} or \code{FALSE} (default), show eigenvalue table
#' @param factorCor \code{TRUE} or \code{FALSE} (default), show factor
#'   correlations
#' @param factorSummary \code{TRUE} or \code{FALSE} (default), show factor
#'   summary
#' @param modelFit \code{TRUE} or \code{FALSE} (default), show model fit
#'   measures and test
#' @param kmo \code{TRUE} or \code{FALSE} (default), show Kaiser-Meyer-Olkin
#'   (KMO) measure of sampling adequacy (MSA) results
#' @param bartlett \code{TRUE} or \code{FALSE} (default), show Bartlett's test
#'   of sphericity results
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$text} \tab \tab \tab \tab \tab a preformatted \cr
#' }
#'
#' @export
efa <- function(
    data,
    vars,
    nFactorMethod = "parallel",
    nFactors = 1,
    minEigen = 1,
    extraction = "minres",
    rotation = "oblimin",
    hideLoadings = 0.3,
    sortLoadings = FALSE,
    screePlot = FALSE,
    eigen = FALSE,
    factorCor = FALSE,
    factorSummary = FALSE,
    modelFit = FALSE,
    kmo = FALSE,
    bartlett = FALSE) {

    if ( ! requireNamespace('jmvcore'))
        stop('efa requires jmvcore to be installed (restart may be required)')

    if (missing(data))
        data <- jmvcore:::marshalData(
            parent.frame(),
            `if`( ! missing(vars), vars, NULL))

    vars <- `if`( ! missing(vars), vars, colnames(data))

    options <- efaOptions$new(
        vars = vars,
        nFactorMethod = nFactorMethod,
        nFactors = nFactors,
        minEigen = minEigen,
        extraction = extraction,
        rotation = rotation,
        hideLoadings = hideLoadings,
        sortLoadings = sortLoadings,
        screePlot = screePlot,
        eigen = eigen,
        factorCor = factorCor,
        factorSummary = factorSummary,
        modelFit = modelFit,
        kmo = kmo,
        bartlett = bartlett)

    results <- efaResults$new(
        options = options)

    analysis <- efaClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
