
# This file is automatically generated, you probably don't want to edit this

linRegOptions <- if (requireNamespace('jmvcore')) R6::R6Class(
    "linRegOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            dep = NULL,
            covs = NULL,
            factors = NULL,
            blocks = list(
                list()),
            refLevels = NULL,
            r = TRUE,
            r2 = TRUE,
            r2Adj = FALSE,
            aic = FALSE,
            bic = FALSE,
            rmse = FALSE,
            modelTest = FALSE,
            anova = FALSE,
            ci = FALSE,
            ciWidth = 95,
            stdEst = FALSE,
            ciStdEst = FALSE,
            ciWidthStdEst = 95,
            coefPlot = FALSE,
            qqPlot = FALSE,
            resPlots = FALSE,
            durbin = FALSE,
            collin = FALSE,
            cooks = FALSE,
            emMeans = list(
                list()),
            ciEmm = TRUE,
            ciWidthEmm = 95,
            emmPlots = TRUE,
            emmTables = FALSE,
            emmWeights = TRUE, ...) {

            super$initialize(
                package='jmv',
                name='linReg',
                requiresData=TRUE,
                ...)

            private$..dep <- jmvcore::OptionVariable$new(
                "dep",
                dep,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "continuous",
                    "nominal",
                    "ordinal"))
            private$..covs <- jmvcore::OptionVariables$new(
                "covs",
                covs,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "continuous",
                    "nominal",
                    "ordinal"),
                default=NULL)
            private$..factors <- jmvcore::OptionVariables$new(
                "factors",
                factors,
                suggested=list(
                    "nominal"),
                permitted=list(
                    "nominal",
                    "nominaltext",
                    "ordinal"),
                default=NULL)
            private$..blocks <- jmvcore::OptionArray$new(
                "blocks",
                blocks,
                default=list(
                    list()),
                template=jmvcore::OptionTerms$new(
                    "blocks",
                    NULL))
            private$..refLevels <- jmvcore::OptionArray$new(
                "refLevels",
                refLevels,
                items="(factors)",
                default=NULL,
                template=jmvcore::OptionGroup$new(
                    "refLevels",
                    NULL,
                    elements=list(
                        jmvcore::OptionVariable$new(
                            "var",
                            NULL,
                            content="$key"),
                        jmvcore::OptionLevel$new(
                            "ref",
                            NULL))))
            private$..r <- jmvcore::OptionBool$new(
                "r",
                r,
                default=TRUE)
            private$..r2 <- jmvcore::OptionBool$new(
                "r2",
                r2,
                default=TRUE)
            private$..r2Adj <- jmvcore::OptionBool$new(
                "r2Adj",
                r2Adj,
                default=FALSE)
            private$..aic <- jmvcore::OptionBool$new(
                "aic",
                aic,
                default=FALSE)
            private$..bic <- jmvcore::OptionBool$new(
                "bic",
                bic,
                default=FALSE)
            private$..rmse <- jmvcore::OptionBool$new(
                "rmse",
                rmse,
                default=FALSE)
            private$..modelTest <- jmvcore::OptionBool$new(
                "modelTest",
                modelTest,
                default=FALSE)
            private$..anova <- jmvcore::OptionBool$new(
                "anova",
                anova,
                default=FALSE)
            private$..ci <- jmvcore::OptionBool$new(
                "ci",
                ci,
                default=FALSE)
            private$..ciWidth <- jmvcore::OptionNumber$new(
                "ciWidth",
                ciWidth,
                min=50,
                max=99.9,
                default=95)
            private$..stdEst <- jmvcore::OptionBool$new(
                "stdEst",
                stdEst,
                default=FALSE)
            private$..ciStdEst <- jmvcore::OptionBool$new(
                "ciStdEst",
                ciStdEst,
                default=FALSE)
            private$..ciWidthStdEst <- jmvcore::OptionNumber$new(
                "ciWidthStdEst",
                ciWidthStdEst,
                min=50,
                max=99.9,
                default=95)
            private$..coefPlot <- jmvcore::OptionBool$new(
                "coefPlot",
                coefPlot,
                default=FALSE,
                hidden=TRUE)
            private$..qqPlot <- jmvcore::OptionBool$new(
                "qqPlot",
                qqPlot,
                default=FALSE)
            private$..resPlots <- jmvcore::OptionBool$new(
                "resPlots",
                resPlots,
                default=FALSE)
            private$..durbin <- jmvcore::OptionBool$new(
                "durbin",
                durbin,
                default=FALSE)
            private$..collin <- jmvcore::OptionBool$new(
                "collin",
                collin,
                default=FALSE)
            private$..cooks <- jmvcore::OptionBool$new(
                "cooks",
                cooks,
                default=FALSE)
            private$..emMeans <- jmvcore::OptionArray$new(
                "emMeans",
                emMeans,
                default=list(
                    list()),
                template=jmvcore::OptionVariables$new(
                    "emMeans",
                    NULL))
            private$..ciEmm <- jmvcore::OptionBool$new(
                "ciEmm",
                ciEmm,
                default=TRUE)
            private$..ciWidthEmm <- jmvcore::OptionNumber$new(
                "ciWidthEmm",
                ciWidthEmm,
                min=50,
                max=99.9,
                default=95)
            private$..emmPlots <- jmvcore::OptionBool$new(
                "emmPlots",
                emmPlots,
                default=TRUE)
            private$..emmTables <- jmvcore::OptionBool$new(
                "emmTables",
                emmTables,
                default=FALSE)
            private$..emmWeights <- jmvcore::OptionBool$new(
                "emmWeights",
                emmWeights,
                default=TRUE)

            self$.addOption(private$..dep)
            self$.addOption(private$..covs)
            self$.addOption(private$..factors)
            self$.addOption(private$..blocks)
            self$.addOption(private$..refLevels)
            self$.addOption(private$..r)
            self$.addOption(private$..r2)
            self$.addOption(private$..r2Adj)
            self$.addOption(private$..aic)
            self$.addOption(private$..bic)
            self$.addOption(private$..rmse)
            self$.addOption(private$..modelTest)
            self$.addOption(private$..anova)
            self$.addOption(private$..ci)
            self$.addOption(private$..ciWidth)
            self$.addOption(private$..stdEst)
            self$.addOption(private$..ciStdEst)
            self$.addOption(private$..ciWidthStdEst)
            self$.addOption(private$..coefPlot)
            self$.addOption(private$..qqPlot)
            self$.addOption(private$..resPlots)
            self$.addOption(private$..durbin)
            self$.addOption(private$..collin)
            self$.addOption(private$..cooks)
            self$.addOption(private$..emMeans)
            self$.addOption(private$..ciEmm)
            self$.addOption(private$..ciWidthEmm)
            self$.addOption(private$..emmPlots)
            self$.addOption(private$..emmTables)
            self$.addOption(private$..emmWeights)
        }),
    active = list(
        dep = function() private$..dep$value,
        covs = function() private$..covs$value,
        factors = function() private$..factors$value,
        blocks = function() private$..blocks$value,
        refLevels = function() private$..refLevels$value,
        r = function() private$..r$value,
        r2 = function() private$..r2$value,
        r2Adj = function() private$..r2Adj$value,
        aic = function() private$..aic$value,
        bic = function() private$..bic$value,
        rmse = function() private$..rmse$value,
        modelTest = function() private$..modelTest$value,
        anova = function() private$..anova$value,
        ci = function() private$..ci$value,
        ciWidth = function() private$..ciWidth$value,
        stdEst = function() private$..stdEst$value,
        ciStdEst = function() private$..ciStdEst$value,
        ciWidthStdEst = function() private$..ciWidthStdEst$value,
        coefPlot = function() private$..coefPlot$value,
        qqPlot = function() private$..qqPlot$value,
        resPlots = function() private$..resPlots$value,
        durbin = function() private$..durbin$value,
        collin = function() private$..collin$value,
        cooks = function() private$..cooks$value,
        emMeans = function() private$..emMeans$value,
        ciEmm = function() private$..ciEmm$value,
        ciWidthEmm = function() private$..ciWidthEmm$value,
        emmPlots = function() private$..emmPlots$value,
        emmTables = function() private$..emmTables$value,
        emmWeights = function() private$..emmWeights$value),
    private = list(
        ..dep = NA,
        ..covs = NA,
        ..factors = NA,
        ..blocks = NA,
        ..refLevels = NA,
        ..r = NA,
        ..r2 = NA,
        ..r2Adj = NA,
        ..aic = NA,
        ..bic = NA,
        ..rmse = NA,
        ..modelTest = NA,
        ..anova = NA,
        ..ci = NA,
        ..ciWidth = NA,
        ..stdEst = NA,
        ..ciStdEst = NA,
        ..ciWidthStdEst = NA,
        ..coefPlot = NA,
        ..qqPlot = NA,
        ..resPlots = NA,
        ..durbin = NA,
        ..collin = NA,
        ..cooks = NA,
        ..emMeans = NA,
        ..ciEmm = NA,
        ..ciWidthEmm = NA,
        ..emmPlots = NA,
        ..emmTables = NA,
        ..emmWeights = NA)
)

linRegResults <- if (requireNamespace('jmvcore')) R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        modelFit = function() private$.items[["modelFit"]],
        modelComp = function() private$.items[["modelComp"]],
        models = function() private$.items[["models"]]),
    private = list(),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="Linear Regression")
            self$add(jmvcore::Table$new(
                options=options,
                name="modelFit",
                title="Model Fit Measures",
                clearWith=list(
                    "dep",
                    "blocks"),
                visible="(r || r2 || r2Adj || aic || bic || rmse || modelTest)",
                columns=list(
                    list(
                        `name`="model", 
                        `title`="Model", 
                        `type`="text"),
                    list(
                        `name`="r", 
                        `title`="R", 
                        `type`="number", 
                        `visible`="(r)"),
                    list(
                        `name`="r2", 
                        `title`="R\u00B2", 
                        `type`="number", 
                        `visible`="(r2)"),
                    list(
                        `name`="r2Adj", 
                        `title`="Adjusted R\u00B2", 
                        `type`="number", 
                        `visible`="(r2Adj)"),
                    list(
                        `name`="aic", 
                        `title`="AIC", 
                        `type`="number", 
                        `visible`="(aic)"),
                    list(
                        `name`="bic", 
                        `title`="BIC", 
                        `type`="number", 
                        `visible`="(bic)"),
                    list(
                        `name`="rmse", 
                        `title`="RMSE", 
                        `type`="number", 
                        `visible`="(rmse)"),
                    list(
                        `name`="f", 
                        `title`="F", 
                        `type`="number", 
                        `superTitle`="Overall Model Test", 
                        `visible`="(modelTest)"),
                    list(
                        `name`="df1", 
                        `title`="df1", 
                        `type`="integer", 
                        `superTitle`="Overall Model Test", 
                        `visible`="(modelTest)"),
                    list(
                        `name`="df2", 
                        `title`="df2", 
                        `type`="integer", 
                        `superTitle`="Overall Model Test", 
                        `visible`="(modelTest)"),
                    list(
                        `name`="p", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `superTitle`="Overall Model Test", 
                        `visible`="(modelTest)"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="modelComp",
                title="Model Comparisons",
                clearWith=list(
                    "dep",
                    "blocks"),
                columns=list(
                    list(
                        `name`="model1", 
                        `title`="Model", 
                        `content`=".", 
                        `type`="text", 
                        `superTitle`="Comparison"),
                    list(
                        `name`="sep", 
                        `title`="", 
                        `content`="-", 
                        `type`="text", 
                        `format`="narrow", 
                        `superTitle`="Comparison"),
                    list(
                        `name`="model2", 
                        `title`="Model", 
                        `content`=".", 
                        `type`="text", 
                        `superTitle`="Comparison"),
                    list(
                        `name`="r2", 
                        `title`="\u0394R\u00B2", 
                        `type`="number"),
                    list(
                        `name`="f", 
                        `title`="F", 
                        `type`="number"),
                    list(
                        `name`="df1", 
                        `title`="df1", 
                        `type`="integer"),
                    list(
                        `name`="df2", 
                        `title`="df2", 
                        `type`="integer"),
                    list(
                        `name`="p", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue"))))
            self$add(jmvcore::Array$new(
                options=options,
                name="models",
                title="Model Specific Results",
                layout="listSelect",
                hideHeadingOnlyChild=TRUE,
                clearWith=list(
                    "blocks"),
                template=R6::R6Class(
                    inherit = jmvcore::Group,
                    active = list(
                        anova = function() private$.items[["anova"]],
                        coef = function() private$.items[["coef"]],
                        coefPlot = function() private$.items[["coefPlot"]],
                        dataSummary = function() private$.items[["dataSummary"]],
                        assump = function() private$.items[["assump"]],
                        emm = function() private$.items[["emm"]]),
                    private = list(),
                    public=list(
                        initialize=function(options) {
                            super$initialize(
                                options=options,
                                name="undefined",
                                title="")
                            self$add(jmvcore::Table$new(
                                options=options,
                                name="anova",
                                title="Omnibus ANOVA Test",
                                visible="(anova)",
                                clearWith=list(
                                    "dep",
                                    "blocks"),
                                columns=list(
                                    list(
                                        `name`="term", 
                                        `title`="", 
                                        `type`="text"),
                                    list(
                                        `name`="ss", 
                                        `title`="Sum of Squares", 
                                        `type`="number"),
                                    list(
                                        `name`="df", 
                                        `title`="df", 
                                        `type`="integer"),
                                    list(
                                        `name`="ms", 
                                        `title`="Mean Square", 
                                        `type`="number"),
                                    list(
                                        `name`="F", 
                                        `title`="F", 
                                        `type`="number"),
                                    list(
                                        `name`="p", 
                                        `title`="p", 
                                        `type`="number", 
                                        `format`="zto,pvalue"))))
                            self$add(jmvcore::Table$new(
                                options=options,
                                name="coef",
                                title="Model Coefficients",
                                clearWith=list(
                                    "dep",
                                    "blocks",
                                    "refLevels",
                                    "ciWidth",
                                    "ciWidthStdEst"),
                                columns=list(
                                    list(
                                        `name`="term", 
                                        `title`="Predictor", 
                                        `type`="text"),
                                    list(
                                        `name`="est", 
                                        `title`="Estimate", 
                                        `type`="number"),
                                    list(
                                        `name`="se", 
                                        `title`="SE", 
                                        `type`="number"),
                                    list(
                                        `name`="lower", 
                                        `title`="Lower", 
                                        `type`="number", 
                                        `visible`="(ci)"),
                                    list(
                                        `name`="upper", 
                                        `title`="Upper", 
                                        `type`="number", 
                                        `visible`="(ci)"),
                                    list(
                                        `name`="t", 
                                        `title`="t", 
                                        `type`="number"),
                                    list(
                                        `name`="p", 
                                        `title`="p", 
                                        `type`="number", 
                                        `format`="zto,pvalue"),
                                    list(
                                        `name`="stdEst", 
                                        `title`="Stand. Estimate", 
                                        `type`="number", 
                                        `visible`="(stdEst)"),
                                    list(
                                        `name`="stdEstLower", 
                                        `title`="Lower", 
                                        `type`="number", 
                                        `visible`="(ciStdEst && stdEst)"),
                                    list(
                                        `name`="stdEstUpper", 
                                        `title`="Upper", 
                                        `type`="number", 
                                        `visible`="(ciStdEst && stdEst)"))))
                            self$add(jmvcore::Image$new(
                                options=options,
                                name="coefPlot",
                                title="Coefficient Plot",
                                width=550,
                                height=500,
                                renderFun=".coefPlot",
                                visible="(coefPlot)",
                                clearWith=list(
                                    "dep",
                                    "blocks",
                                    "ciWidth")))
                            self$add(R6::R6Class(
                                inherit = jmvcore::Group,
                                active = list(
                                    cooks = function() private$.items[["cooks"]]),
                                private = list(),
                                public=list(
                                    initialize=function(options) {
                                        super$initialize(
                                            options=options,
                                            name="dataSummary",
                                            title="Data Summary")
                                        self$add(jmvcore::Table$new(
                                            options=options,
                                            name="cooks",
                                            title="Cook's Distance",
                                            rows=1,
                                            visible="(cooks)",
                                            clearWith=list(
                                                "dep",
                                                "blocks"),
                                            columns=list(
                                                list(
                                                    `name`="mean", 
                                                    `title`="Mean", 
                                                    `type`="number"),
                                                list(
                                                    `name`="median", 
                                                    `title`="Median", 
                                                    `type`="number"),
                                                list(
                                                    `name`="sd", 
                                                    `title`="SD", 
                                                    `type`="number"),
                                                list(
                                                    `name`="min", 
                                                    `title`="Min", 
                                                    `type`="number", 
                                                    `superTitle`="Range"),
                                                list(
                                                    `name`="max", 
                                                    `title`="Max", 
                                                    `type`="number", 
                                                    `superTitle`="Range"))))}))$new(options=options))
                            self$add(R6::R6Class(
                                inherit = jmvcore::Group,
                                active = list(
                                    durbin = function() private$.items[["durbin"]],
                                    collin = function() private$.items[["collin"]],
                                    qqPlot = function() private$.items[["qqPlot"]],
                                    resPlots = function() private$.items[["resPlots"]]),
                                private = list(),
                                public=list(
                                    initialize=function(options) {
                                        super$initialize(
                                            options=options,
                                            name="assump",
                                            title="Assumption Checks")
                                        self$add(jmvcore::Table$new(
                                            options=options,
                                            name="durbin",
                                            title="Durbin\u2013Watson Test for Autocorrelation",
                                            rows=1,
                                            visible="(durbin)",
                                            clearWith=list(
                                                "dep",
                                                "blocks"),
                                            columns=list(
                                                list(
                                                    `name`="autoCor", 
                                                    `title`="Autocorrelation", 
                                                    `type`="number"),
                                                list(
                                                    `name`="dw", 
                                                    `title`="DW Statistic", 
                                                    `type`="number"),
                                                list(
                                                    `name`="p", 
                                                    `title`="p", 
                                                    `type`="number", 
                                                    `format`="zto,pvalue"))))
                                        self$add(jmvcore::Table$new(
                                            options=options,
                                            name="collin",
                                            title="Collinearity Statistics",
                                            visible="(collin)",
                                            clearWith=list(
                                                "dep",
                                                "blocks"),
                                            columns=list(
                                                list(
                                                    `name`="term", 
                                                    `title`="", 
                                                    `type`="text"),
                                                list(
                                                    `name`="vif", 
                                                    `title`="VIF", 
                                                    `type`="number"),
                                                list(
                                                    `name`="tol", 
                                                    `title`="Tolerance", 
                                                    `type`="number"))))
                                        self$add(jmvcore::Image$new(
                                            options=options,
                                            name="qqPlot",
                                            title="Q-Q Plot",
                                            width=450,
                                            height=400,
                                            renderFun=".qqPlot",
                                            visible="(qqPlot)",
                                            clearWith=list(
                                                "dep",
                                                "blocks")))
                                        self$add(jmvcore::Array$new(
                                            options=options,
                                            name="resPlots",
                                            title="Residuals Plots",
                                            visible="(resPlots)",
                                            template=jmvcore::Image$new(
                                                options=options,
                                                renderFun=".resPlot",
                                                clearWith=list(
                                                    "dep",
                                                    "blocks"))))}))$new(options=options))
                            self$add(jmvcore::Array$new(
                                options=options,
                                name="emm",
                                title="Estimated Marginal Means",
                                clearWith=list(
                                    "dep",
                                    "blocks",
                                    "emMeans"),
                                template=R6::R6Class(
                                    inherit = jmvcore::Group,
                                    active = list(
                                        emmPlot = function() private$.items[["emmPlot"]],
                                        emmTable = function() private$.items[["emmTable"]]),
                                    private = list(),
                                    public=list(
                                        initialize=function(options) {
                                            super$initialize(
                                                options=options,
                                                name="undefined",
                                                title="")
                                            self$add(jmvcore::Image$new(
                                                options=options,
                                                name="emmPlot",
                                                title="",
                                                width=450,
                                                height=400,
                                                renderFun=".emmPlot",
                                                visible="(emmPlots)",
                                                clearWith=list(
                                                    "dep",
                                                    "blocks",
                                                    "refLevels",
                                                    "ciEmm",
                                                    "ciWidthEmm",
                                                    "emmWeights")))
                                            self$add(jmvcore::Table$new(
                                                options=options,
                                                name="emmTable",
                                                title="",
                                                visible="(emmTables)",
                                                columns=list(),
                                                clearWith=list(
                                                    "dep",
                                                    "blocks",
                                                    "refLevels",
                                                    "ciWidthEmm",
                                                    "emmWeights")))}))$new(options=options)))}))$new(options=options)))}))

linRegBase <- if (requireNamespace('jmvcore')) R6::R6Class(
    "linRegBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'linReg',
                version = c(2,0,0),
                options = options,
                results = linRegResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = FALSE)
        }))

#' Linear Regression
#'
#' Linear Regression
#'
#' @examples
#' data('Prestige', package='carData')
#'
#' linReg(data = Prestige, dep = 'income',
#'        covs = c('education', 'prestige', 'women'),
#'        blocks = list(list('education', 'prestige', 'women')))
#'
#' #
#' #  LINEAR REGRESSION
#' #
#' #  Model Fit Measures
#' #  ---------------------------
#' #    Model    R        R²
#' #  ---------------------------
#' #        1    0.802    0.643
#' #  ---------------------------
#' #
#' #
#' #  MODEL SPECIFIC RESULTS
#' #
#' #  MODEL 1
#' #
#' #
#' #  Model Coefficients
#' #  --------------------------------------------------------
#' #    Predictor    Estimate    SE         t         p
#' #  --------------------------------------------------------
#' #    Intercept      -253.8    1086.16    -0.234     0.816
#' #    women           -50.9       8.56    -5.948    < .001
#' #    prestige        141.4      29.91     4.729    < .001
#' #    education       177.2     187.63     0.944     0.347
#' #  --------------------------------------------------------
#' #
#'
#' @param data the data as a data frame
#' @param dep a string naming the dependent variable from \code{data},
#'   variable must be numeric
#' @param covs a vector of strings naming the covariates from \code{data}
#' @param factors a vector of strings naming the fixed factors from
#'   \code{data}
#' @param blocks a list containing vectors of strings that name the predictors
#'   that are added to the model. The elements are added to the model according
#'   to their order in the list
#' @param refLevels a list of lists specifying reference levels of the
#'   dependent variable and all the factors
#' @param r \code{TRUE} (default) or \code{FALSE}, provide the statistical
#'   measure \code{R} for the models
#' @param r2 \code{TRUE} (default) or \code{FALSE}, provide the statistical
#'   measure \code{R-squared} for the models
#' @param r2Adj \code{TRUE} or \code{FALSE} (default), provide the statistical
#'   measure \code{adjusted R-squared} for the models
#' @param aic \code{TRUE} or \code{FALSE} (default), provide Aikaike's
#'   Information Criterion (AIC) for the models
#' @param bic \code{TRUE} or \code{FALSE} (default), provide Bayesian
#'   Information Criterion (BIC) for the models
#' @param rmse \code{TRUE} or \code{FALSE} (default), provide RMSE for the
#'   models
#' @param modelTest \code{TRUE} (default) or \code{FALSE}, provide the model
#'   comparison between the models and the NULL model
#' @param anova \code{TRUE} or \code{FALSE} (default), provide the omnibus
#'   ANOVA test for the predictors
#' @param ci \code{TRUE} or \code{FALSE} (default), provide a confidence
#'   interval for the model coefficients
#' @param ciWidth a number between 50 and 99.9 (default: 95) specifying the
#'   confidence interval width
#' @param stdEst \code{TRUE} or \code{FALSE} (default), provide a standardized
#'   estimate for the model coefficients
#' @param ciStdEst \code{TRUE} or \code{FALSE} (default), provide a confidence
#'   interval for the model coefficient standardized estimates
#' @param ciWidthStdEst a number between 50 and 99.9 (default: 95) specifying
#'   the confidence interval width
#' @param coefPlot \code{TRUE} or \code{FALSE} (default), provide a
#'   coefficient plot where for each predictor the estimated coefficient and
#'   confidence intervals are plotted.
#' @param qqPlot \code{TRUE} or \code{FALSE} (default), provide a Q-Q plot of
#'   residuals
#' @param resPlots \code{TRUE} or \code{FALSE} (default), provide residual
#'   plots where the dependent variable and each covariate is plotted against
#'   the standardized residuals.
#' @param durbin \code{TRUE} or \code{FALSE} (default), provide results of the
#'   Durbin- Watson test for autocorrelation
#' @param collin \code{TRUE} or \code{FALSE} (default), provide VIF and
#'   tolerence collinearity statistics
#' @param cooks \code{TRUE} or \code{FALSE} (default), provide summary
#'   statistics for the Cook's distance
#' @param emMeans a list of lists specifying the variables for which the
#'   estimated marginal means need to be calculate. Supports up to three
#'   variables per term.
#' @param ciEmm \code{TRUE} (default) or \code{FALSE}, provide a confidence
#'   interval for the estimated marginal means
#' @param ciWidthEmm a number between 50 and 99.9 (default: 95) specifying the
#'   confidence interval width for the estimated marginal means
#' @param emmPlots \code{TRUE} (default) or \code{FALSE}, provide estimated
#'   marginal means plots
#' @param emmTables \code{TRUE} or \code{FALSE} (default), provide estimated
#'   marginal means tables
#' @param emmWeights \code{TRUE} (default) or \code{FALSE}, weigh each cell
#'   equally or weigh them according to the cell frequency
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$modelFit} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$modelComp} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$models} \tab \tab \tab \tab \tab an array of model specific results \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$modelFit$asDF}
#'
#' \code{as.data.frame(results$modelFit)}
#'
#' @export
linReg <- function(
    data,
    dep,
    covs = NULL,
    factors = NULL,
    blocks = list(
                list()),
    refLevels = NULL,
    r = TRUE,
    r2 = TRUE,
    r2Adj = FALSE,
    aic = FALSE,
    bic = FALSE,
    rmse = FALSE,
    modelTest = FALSE,
    anova = FALSE,
    ci = FALSE,
    ciWidth = 95,
    stdEst = FALSE,
    ciStdEst = FALSE,
    ciWidthStdEst = 95,
    coefPlot = FALSE,
    qqPlot = FALSE,
    resPlots = FALSE,
    durbin = FALSE,
    collin = FALSE,
    cooks = FALSE,
    emMeans = list(
                list()),
    ciEmm = TRUE,
    ciWidthEmm = 95,
    emmPlots = TRUE,
    emmTables = FALSE,
    emmWeights = TRUE) {

    if ( ! requireNamespace('jmvcore'))
        stop('linReg requires jmvcore to be installed (restart may be required)')

    options <- linRegOptions$new(
        dep = dep,
        covs = covs,
        factors = factors,
        blocks = blocks,
        refLevels = refLevels,
        r = r,
        r2 = r2,
        r2Adj = r2Adj,
        aic = aic,
        bic = bic,
        rmse = rmse,
        modelTest = modelTest,
        anova = anova,
        ci = ci,
        ciWidth = ciWidth,
        stdEst = stdEst,
        ciStdEst = ciStdEst,
        ciWidthStdEst = ciWidthStdEst,
        coefPlot = coefPlot,
        qqPlot = qqPlot,
        resPlots = resPlots,
        durbin = durbin,
        collin = collin,
        cooks = cooks,
        emMeans = emMeans,
        ciEmm = ciEmm,
        ciWidthEmm = ciWidthEmm,
        emmPlots = emmPlots,
        emmTables = emmTables,
        emmWeights = emmWeights)

    results <- linRegResults$new(
        options = options)

    analysis <- linRegClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
