
# This file is automatically generated, you probably don't want to edit this

contTablesOptions <- if (requireNamespace('jmvcore')) R6::R6Class(
    "contTablesOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            rows = NULL,
            cols = NULL,
            counts = NULL,
            layers = NULL,
            chiSq = TRUE,
            chiSqCorr = FALSE,
            likeRat = FALSE,
            fisher = FALSE,
            contCoef = FALSE,
            phiCra = FALSE,
            logOdds = FALSE,
            odds = FALSE,
            relRisk = FALSE,
            ci = TRUE,
            ciWidth = 95,
            gamma = FALSE,
            taub = FALSE,
            exp = FALSE,
            pcRow = FALSE,
            pcCol = FALSE,
            pcTot = FALSE, ...) {

            super$initialize(
                package='jmv',
                name='contTables',
                requiresData=TRUE,
                ...)

            private$..rows <- jmvcore::OptionVariable$new(
                "rows",
                rows,
                suggested=list(
                    "nominal",
                    "ordinal"))
            private$..cols <- jmvcore::OptionVariable$new(
                "cols",
                cols,
                suggested=list(
                    "nominal",
                    "ordinal"))
            private$..counts <- jmvcore::OptionVariable$new(
                "counts",
                counts,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "continuous",
                    "nominal",
                    "ordinal"),
                default=NULL)
            private$..layers <- jmvcore::OptionVariables$new(
                "layers",
                layers,
                default=NULL)
            private$..chiSq <- jmvcore::OptionBool$new(
                "chiSq",
                chiSq,
                default=TRUE)
            private$..chiSqCorr <- jmvcore::OptionBool$new(
                "chiSqCorr",
                chiSqCorr,
                default=FALSE)
            private$..likeRat <- jmvcore::OptionBool$new(
                "likeRat",
                likeRat,
                default=FALSE)
            private$..fisher <- jmvcore::OptionBool$new(
                "fisher",
                fisher,
                default=FALSE)
            private$..contCoef <- jmvcore::OptionBool$new(
                "contCoef",
                contCoef,
                default=FALSE)
            private$..phiCra <- jmvcore::OptionBool$new(
                "phiCra",
                phiCra,
                default=FALSE)
            private$..logOdds <- jmvcore::OptionBool$new(
                "logOdds",
                logOdds,
                default=FALSE)
            private$..odds <- jmvcore::OptionBool$new(
                "odds",
                odds,
                default=FALSE)
            private$..relRisk <- jmvcore::OptionBool$new(
                "relRisk",
                relRisk,
                default=FALSE)
            private$..ci <- jmvcore::OptionBool$new(
                "ci",
                ci,
                default=TRUE)
            private$..ciWidth <- jmvcore::OptionNumber$new(
                "ciWidth",
                ciWidth,
                min=50,
                max=99.9,
                default=95)
            private$..gamma <- jmvcore::OptionBool$new(
                "gamma",
                gamma,
                default=FALSE)
            private$..taub <- jmvcore::OptionBool$new(
                "taub",
                taub,
                default=FALSE)
            private$..exp <- jmvcore::OptionBool$new(
                "exp",
                exp,
                default=FALSE)
            private$..pcRow <- jmvcore::OptionBool$new(
                "pcRow",
                pcRow,
                default=FALSE)
            private$..pcCol <- jmvcore::OptionBool$new(
                "pcCol",
                pcCol,
                default=FALSE)
            private$..pcTot <- jmvcore::OptionBool$new(
                "pcTot",
                pcTot,
                default=FALSE)

            self$.addOption(private$..rows)
            self$.addOption(private$..cols)
            self$.addOption(private$..counts)
            self$.addOption(private$..layers)
            self$.addOption(private$..chiSq)
            self$.addOption(private$..chiSqCorr)
            self$.addOption(private$..likeRat)
            self$.addOption(private$..fisher)
            self$.addOption(private$..contCoef)
            self$.addOption(private$..phiCra)
            self$.addOption(private$..logOdds)
            self$.addOption(private$..odds)
            self$.addOption(private$..relRisk)
            self$.addOption(private$..ci)
            self$.addOption(private$..ciWidth)
            self$.addOption(private$..gamma)
            self$.addOption(private$..taub)
            self$.addOption(private$..exp)
            self$.addOption(private$..pcRow)
            self$.addOption(private$..pcCol)
            self$.addOption(private$..pcTot)
        }),
    active = list(
        rows = function() private$..rows$value,
        cols = function() private$..cols$value,
        counts = function() private$..counts$value,
        layers = function() private$..layers$value,
        chiSq = function() private$..chiSq$value,
        chiSqCorr = function() private$..chiSqCorr$value,
        likeRat = function() private$..likeRat$value,
        fisher = function() private$..fisher$value,
        contCoef = function() private$..contCoef$value,
        phiCra = function() private$..phiCra$value,
        logOdds = function() private$..logOdds$value,
        odds = function() private$..odds$value,
        relRisk = function() private$..relRisk$value,
        ci = function() private$..ci$value,
        ciWidth = function() private$..ciWidth$value,
        gamma = function() private$..gamma$value,
        taub = function() private$..taub$value,
        exp = function() private$..exp$value,
        pcRow = function() private$..pcRow$value,
        pcCol = function() private$..pcCol$value,
        pcTot = function() private$..pcTot$value),
    private = list(
        ..rows = NA,
        ..cols = NA,
        ..counts = NA,
        ..layers = NA,
        ..chiSq = NA,
        ..chiSqCorr = NA,
        ..likeRat = NA,
        ..fisher = NA,
        ..contCoef = NA,
        ..phiCra = NA,
        ..logOdds = NA,
        ..odds = NA,
        ..relRisk = NA,
        ..ci = NA,
        ..ciWidth = NA,
        ..gamma = NA,
        ..taub = NA,
        ..exp = NA,
        ..pcRow = NA,
        ..pcCol = NA,
        ..pcTot = NA)
)

contTablesResults <- if (requireNamespace('jmvcore')) R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        freqs = function() private$.items[["freqs"]],
        chiSq = function() private$.items[["chiSq"]],
        odds = function() private$.items[["odds"]],
        nom = function() private$.items[["nom"]],
        gamma = function() private$.items[["gamma"]],
        taub = function() private$.items[["taub"]]),
    private = list(),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="Contingency Tables")
            self$add(jmvcore::Table$new(
                options=options,
                name="freqs",
                title="Contingency Tables",
                columns=list(),
                clearWith=list(
                    "rows",
                    "cols",
                    "counts",
                    "layers")))
            self$add(jmvcore::Table$new(
                options=options,
                name="chiSq",
                title="\u03C7\u00B2 Tests",
                clearWith=list(
                    "rows",
                    "cols",
                    "counts",
                    "layers"),
                columns=list(
                    list(
                        `name`="test[chiSq]", 
                        `title`="", 
                        `type`="text", 
                        `content`="\u03C7\u00B2", 
                        `visible`="(chiSq)"),
                    list(
                        `name`="value[chiSq]", 
                        `title`="Value", 
                        `visible`="(chiSq)"),
                    list(
                        `name`="df[chiSq]", 
                        `title`="df", 
                        `type`="integer", 
                        `visible`="(chiSq)"),
                    list(
                        `name`="p[chiSq]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(chiSq)"),
                    list(
                        `name`="test[chiSqCorr]", 
                        `title`="", 
                        `type`="text", 
                        `content`="\u03C7\u00B2 continuity correction", 
                        `visible`="(chiSqCorr)"),
                    list(
                        `name`="value[chiSqCorr]", 
                        `title`="Value", 
                        `visible`="(chiSqCorr)"),
                    list(
                        `name`="df[chiSqCorr]", 
                        `title`="df", 
                        `type`="integer", 
                        `visible`="(chiSqCorr)"),
                    list(
                        `name`="p[chiSqCorr]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(chiSqCorr)"),
                    list(
                        `name`="test[likeRat]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Likelihood ratio", 
                        `visible`="(likeRat)"),
                    list(
                        `name`="value[likeRat]", 
                        `title`="Value", 
                        `visible`="(likeRat)"),
                    list(
                        `name`="df[likeRat]", 
                        `title`="df", 
                        `type`="integer", 
                        `visible`="(likeRat)"),
                    list(
                        `name`="p[likeRat]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(likeRat)"),
                    list(
                        `name`="test[fisher]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Fisher's exact test", 
                        `visible`="(fisher)"),
                    list(
                        `name`="value[fisher]", 
                        `title`="Value", 
                        `visible`="(fisher)"),
                    list(
                        `name`="p[fisher]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(fisher)"),
                    list(
                        `name`="test[N]", 
                        `title`="", 
                        `type`="text", 
                        `content`="N"),
                    list(
                        `name`="value[N]", 
                        `title`="Value", 
                        `type`="integer"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="odds",
                title="Comparative Measures",
                visible="(logOdds || odds || relRisk)",
                clearWith=list(
                    "rows",
                    "cols",
                    "counts",
                    "layers",
                    "ciWidth"),
                columns=list(
                    list(
                        `name`="t[lo]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Log odds ratio", 
                        `visible`="(logOdds)"),
                    list(
                        `name`="v[lo]", 
                        `title`="Value", 
                        `visible`="(logOdds)"),
                    list(
                        `name`="cil[lo]", 
                        `title`="Lower", 
                        `superTitle`="Confidence Intervals", 
                        `visible`="(logOdds && ci)"),
                    list(
                        `name`="ciu[lo]", 
                        `title`="Upper", 
                        `superTitle`="Confidence Intervals", 
                        `visible`="(logOdds && ci)"),
                    list(
                        `name`="t[o]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Odds ratio", 
                        `visible`="(odds)"),
                    list(
                        `name`="v[o]", 
                        `title`="Value", 
                        `visible`="(odds)"),
                    list(
                        `name`="cil[o]", 
                        `title`="Lower", 
                        `superTitle`="Confidence Intervals", 
                        `visible`="(odds && ci)"),
                    list(
                        `name`="ciu[o]", 
                        `title`="Upper", 
                        `superTitle`="Confidence Intervals", 
                        `visible`="(odds && ci)"),
                    list(
                        `name`="t[rr]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Relative risk", 
                        `visible`="(relRisk)"),
                    list(
                        `name`="v[rr]", 
                        `title`="Value", 
                        `visible`="(relRisk)"),
                    list(
                        `name`="cil[rr]", 
                        `title`="Lower", 
                        `superTitle`="Confidence Intervals", 
                        `visible`="(relRisk && ci)"),
                    list(
                        `name`="ciu[rr]", 
                        `title`="Upper", 
                        `superTitle`="Confidence Intervals", 
                        `visible`="(relRisk && ci)"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="nom",
                title="Nominal",
                visible="(contCoef || phiCra)",
                columns=list(
                    list(
                        `name`="t[cont]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Contingency coefficient", 
                        `visible`="(contCoef)"),
                    list(
                        `name`="v[cont]", 
                        `title`="Value", 
                        `visible`="(contCoef)"),
                    list(
                        `name`="t[phi]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Phi-coefficient", 
                        `visible`="(phiCra)"),
                    list(
                        `name`="v[phi]", 
                        `title`="Value", 
                        `visible`="(phiCra)"),
                    list(
                        `name`="t[cra]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Cramer's V", 
                        `visible`="(phiCra)"),
                    list(
                        `name`="v[cra]", 
                        `title`="Value", 
                        `visible`="(phiCra)"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="gamma",
                title="Gamma",
                visible="(gamma)",
                clearWith=list(
                    "rows",
                    "cols",
                    "counts",
                    "layers"),
                columns=list(
                    list(
                        `name`="gamma", 
                        `title`="Gamma"),
                    list(
                        `name`="se", 
                        `title`="Standard Error"),
                    list(
                        `name`="cil", 
                        `title`="Lower", 
                        `superTitle`="Confidence Intervals"),
                    list(
                        `name`="ciu", 
                        `title`="Upper", 
                        `superTitle`="Confidence Intervals"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="taub",
                title="Kendall's Tau-b",
                visible="(taub)",
                clearWith=list(
                    "rows",
                    "cols",
                    "counts",
                    "layers"),
                columns=list(
                    list(
                        `name`="taub", 
                        `title`="Kendall's Tau-B"),
                    list(
                        `name`="t", 
                        `title`="t"),
                    list(
                        `name`="p", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue"))))}))

contTablesBase <- if (requireNamespace('jmvcore')) R6::R6Class(
    "contTablesBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'contTables',
                version = c(1,0,0),
                options = options,
                results = contTablesResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = TRUE)
        }))

#' Contingency Tables
#'
#' X² test of association
#'
#' @examples
#' data('HairEyeColor')
#' dat <- as.data.frame(HairEyeColor)
#'
#' contTables(dat, rows = 'Hair', cols = 'Eye', counts = 'Freq')
#'
#' #
#' #  Contingency Tables
#' #
#' #  Contingency Tables
#' #  -----------------------------------------------------
#' #    Hair     Brown    Blue    Hazel    Green    Total
#' #  -----------------------------------------------------
#' #    Black       68      20       15        5      108
#' #    Brown      119      84       54       29      286
#' #    Red         26      17       14       14       71
#' #    Blond        7      94       10       16      127
#' #    Total      220     215       93       64      592
#' #  -----------------------------------------------------
#' #
#' #
#' #  X² Tests
#' #  -------------------------------
#' #          Value    df    p
#' #  -------------------------------
#' #    X²      138     9    < .001
#' #    N       592
#' #  -------------------------------
#' #
#'
#' @param data the data as a data frame
#' @param rows a string naming the variable to use as the rows in the
#'   contingency table
#' @param cols a string naming the variable to use as the columns in the
#'   contingency table
#' @param counts a string naming the variable to use as counts, or NULL if
#'   each row represents a single observation
#' @param layers a character vector naming variables to split the contingency
#'   table across
#' @param chiSq \code{TRUE} (default) or \code{FALSE}, provide X²
#' @param chiSqCorr \code{TRUE} or \code{FALSE} (default), provide X² with
#'   continuity correction
#' @param likeRat \code{TRUE} or \code{FALSE} (default), provide the
#'   likelihood ratio
#' @param fisher \code{TRUE} or \code{FALSE} (default), provide Fisher's exact
#'   test
#' @param contCoef \code{TRUE} or \code{FALSE} (default), provide the
#'   contingency coefficient
#' @param phiCra \code{TRUE} or \code{FALSE} (default), provide Phi and
#'   Cramer's V
#' @param logOdds \code{TRUE} or \code{FALSE} (default), provide the log odds
#'   ratio (only available for 2x2 tables)
#' @param odds \code{TRUE} or \code{FALSE} (default), provide the odds ratio
#'   (only available for 2x2 tables)
#' @param relRisk \code{TRUE} or \code{FALSE} (default), provide the relative
#'   risk (only available for 2x2 tables)
#' @param ci \code{TRUE} or \code{FALSE} (default), provide confidence
#'   intervals for the comparative measures
#' @param ciWidth a number between 50 and 99.9 (default: 95), width of the
#'   confidence intervals to provide
#' @param gamma \code{TRUE} or \code{FALSE} (default), provide gamma
#' @param taub \code{TRUE} or \code{FALSE} (default), provide Kendall's tau-b
#' @param exp \code{TRUE} or \code{FALSE} (default), provide the expected
#'   counts
#' @param pcRow \code{TRUE} or \code{FALSE} (default), provide row percentages
#' @param pcCol \code{TRUE} or \code{FALSE} (default), provide column
#'   percentages
#' @param pcTot \code{TRUE} or \code{FALSE} (default), provide total
#'   percentages
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$freqs} \tab \tab \tab \tab \tab a table of proportions \cr
#'   \code{results$chiSq} \tab \tab \tab \tab \tab a table of X² test results \cr
#'   \code{results$odds} \tab \tab \tab \tab \tab a table of comparative measures \cr
#'   \code{results$nom} \tab \tab \tab \tab \tab a table of the 'nominal' test results \cr
#'   \code{results$gamma} \tab \tab \tab \tab \tab a table of the gamma test results \cr
#'   \code{results$taub} \tab \tab \tab \tab \tab a table of the Kendall's tau-b test results \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$freqs$asDF}
#'
#' \code{as.data.frame(results$freqs)}
#'
#' @export
contTables <- function(
    data,
    rows,
    cols,
    counts = NULL,
    layers = NULL,
    chiSq = TRUE,
    chiSqCorr = FALSE,
    likeRat = FALSE,
    fisher = FALSE,
    contCoef = FALSE,
    phiCra = FALSE,
    logOdds = FALSE,
    odds = FALSE,
    relRisk = FALSE,
    ci = TRUE,
    ciWidth = 95,
    gamma = FALSE,
    taub = FALSE,
    exp = FALSE,
    pcRow = FALSE,
    pcCol = FALSE,
    pcTot = FALSE) {

    if ( ! requireNamespace('jmvcore'))
        stop('contTables requires jmvcore to be installed (restart may be required)')

    options <- contTablesOptions$new(
        rows = rows,
        cols = cols,
        counts = counts,
        layers = layers,
        chiSq = chiSq,
        chiSqCorr = chiSqCorr,
        likeRat = likeRat,
        fisher = fisher,
        contCoef = contCoef,
        phiCra = phiCra,
        logOdds = logOdds,
        odds = odds,
        relRisk = relRisk,
        ci = ci,
        ciWidth = ciWidth,
        gamma = gamma,
        taub = taub,
        exp = exp,
        pcRow = pcRow,
        pcCol = pcCol,
        pcTot = pcTot)

    results <- contTablesResults$new(
        options = options)

    analysis <- contTablesClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
