% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conttables.h.R
\name{contTables}
\alias{contTables}
\title{Contingency Tables}
\usage{
contTables(data, rows, cols, counts = NULL, layers = NULL, chiSq = TRUE,
  chiSqCorr = FALSE, likeRat = FALSE, contCoef = FALSE, phiCra = FALSE,
  logOdds = FALSE, ciWidth = 95, gamma = FALSE, taub = FALSE,
  exp = FALSE, pcRow = FALSE, pcCol = FALSE, pcTot = FALSE)
}
\arguments{
\item{data}{the data as a data frame}

\item{rows}{a string naming the variable to use as the rows in the 
contingency table}

\item{cols}{a string naming the variable to use as the columns in the 
contingency table}

\item{counts}{a string naming the variable to use as counts, or NULL if 
each row represents a single observation}

\item{layers}{a character vector naming variables to split the contingency 
table across}

\item{chiSq}{\code{TRUE} (default) or \code{FALSE}, provide X²}

\item{chiSqCorr}{\code{TRUE} or \code{FALSE} (default), provide X² with 
continuity correction}

\item{likeRat}{\code{TRUE} or \code{FALSE} (default), provide the 
likelihood ratio}

\item{contCoef}{\code{TRUE} or \code{FALSE} (default), provide the 
contingency coefficient}

\item{phiCra}{\code{TRUE} or \code{FALSE} (default), provide Phi and 
Cramer's V}

\item{logOdds}{\code{TRUE} or \code{FALSE} (default), provide the log odds 
ratio (only available for 2x2 tables)}

\item{ciWidth}{a number between 50 and 99.9 (default: 95), width of the 
confidence intervals to provide}

\item{gamma}{\code{TRUE} or \code{FALSE} (default), provide gamma}

\item{taub}{\code{TRUE} or \code{FALSE} (default), provide Kendall's tau-b}

\item{exp}{\code{TRUE} or \code{FALSE} (default), provide the expected 
counts}

\item{pcRow}{\code{TRUE} or \code{FALSE} (default), provide row percentages}

\item{pcCol}{\code{TRUE} or \code{FALSE} (default), provide column 
percentages}

\item{pcTot}{\code{TRUE} or \code{FALSE} (default), provide total 
percentages}
}
\description{
X² test of association
}
\examples{
data('HairEyeColor')
dat <- as.data.frame(HairEyeColor)

contTables(dat, rows = 'Hair', cols = 'Eye', counts = 'Freq')

#
#  Contingency Tables
#
#  Contingency Tables
#  -----------------------------------------------------
#    Hair     Brown    Blue    Hazel    Green    Total
#  -----------------------------------------------------
#    Black       68      20       15        5      108
#    Brown      119      84       54       29      286
#    Red         26      17       14       14       71
#    Blond        7      94       10       16      127
#    Total      220     215       93       64      592
#  -----------------------------------------------------
#
#
#  X² Tests
#  -------------------------------
#          Value    df    p
#  -------------------------------
#    X²      138     9    < .001
#    N       592
#  -------------------------------
#

}
