
# This file is automatically generated, you probably don't want to edit this

#' @importFrom jmvcore Options
#' @importFrom R6 R6Class
ancovaOptions <- R6::R6Class(
    "ancovaOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            dep = NULL,
            factors = NULL,
            covs = NULL,
            modelTerms = NULL,
            ss = "3",
            effectSize = NULL,
            contrasts = NULL,
            plotHAxis = NULL,
            plotSepLines = NULL,
            plotSepPlots = NULL,
            postHoc = NULL,
            postHocCorr = list(
                "tukey"),
            descStats = FALSE,
            homo = FALSE,
            qq = FALSE,
            plotError = "ci",
            ciWidth = 95, ...) {

            super$initialize(
                package='jmv',
                name='ancova',
                requiresData=TRUE,
                ...)
        
            private$..dep <- jmvcore::OptionVariable$new(
                "dep",
                dep,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "continuous",
                    "nominal",
                    "ordinal"))
            private$..factors <- jmvcore::OptionVariables$new(
                "factors",
                factors,
                suggested=list(
                    "nominal",
                    "ordinal"),
                default=NULL)
            private$..covs <- jmvcore::OptionVariables$new(
                "covs",
                covs,
                suggested=list(
                    "continuous",
                    "ordinal"),
                permitted=list(
                    "continuous",
                    "nominal",
                    "ordinal"),
                default=NULL)
            private$..modelTerms <- jmvcore::OptionTerms$new(
                "modelTerms",
                modelTerms,
                default=NULL)
            private$..ss <- jmvcore::OptionList$new(
                "ss",
                ss,
                options=list(
                    "1",
                    "2",
                    "3"),
                default="3")
            private$..effectSize <- jmvcore::OptionNMXList$new(
                "effectSize",
                effectSize,
                options=list(
                    "eta",
                    "partEta",
                    "omega"),
                default=NULL)
            private$..contrasts <- jmvcore::OptionArray$new(
                "contrasts",
                contrasts,
                items="(factors)",
                default=NULL,
                template=jmvcore::OptionGroup$new(
                    "contrasts",
                    NULL,
                    elements=list(
                        jmvcore::OptionVariable$new(
                            "var",
                            NULL,
                            content="$key"),
                        jmvcore::OptionList$new(
                            "type",
                            NULL,
                            options=list(
                                "none",
                                "deviation",
                                "simple",
                                "difference",
                                "helmert",
                                "repeated",
                                "polynomial")))))
            private$..plotHAxis <- jmvcore::OptionVariable$new(
                "plotHAxis",
                plotHAxis,
                default=NULL)
            private$..plotSepLines <- jmvcore::OptionVariable$new(
                "plotSepLines",
                plotSepLines,
                default=NULL)
            private$..plotSepPlots <- jmvcore::OptionVariable$new(
                "plotSepPlots",
                plotSepPlots,
                default=NULL)
            private$..postHoc <- jmvcore::OptionTerms$new(
                "postHoc",
                postHoc,
                default=NULL)
            private$..postHocCorr <- jmvcore::OptionNMXList$new(
                "postHocCorr",
                postHocCorr,
                options=list(
                    "none",
                    "tukey",
                    "scheffe",
                    "bonf",
                    "holm"),
                default=list(
                    "tukey"))
            private$..descStats <- jmvcore::OptionBool$new(
                "descStats",
                descStats,
                default=FALSE)
            private$..homo <- jmvcore::OptionBool$new(
                "homo",
                homo,
                default=FALSE)
            private$..qq <- jmvcore::OptionBool$new(
                "qq",
                qq,
                default=FALSE)
            private$..plotError <- jmvcore::OptionList$new(
                "plotError",
                plotError,
                options=list(
                    "none",
                    "ci",
                    "se"),
                default="ci")
            private$..ciWidth <- jmvcore::OptionNumber$new(
                "ciWidth",
                ciWidth,
                min=50,
                max=99.9,
                default=95)
        
            self$.addOption(private$..dep)
            self$.addOption(private$..factors)
            self$.addOption(private$..covs)
            self$.addOption(private$..modelTerms)
            self$.addOption(private$..ss)
            self$.addOption(private$..effectSize)
            self$.addOption(private$..contrasts)
            self$.addOption(private$..plotHAxis)
            self$.addOption(private$..plotSepLines)
            self$.addOption(private$..plotSepPlots)
            self$.addOption(private$..postHoc)
            self$.addOption(private$..postHocCorr)
            self$.addOption(private$..descStats)
            self$.addOption(private$..homo)
            self$.addOption(private$..qq)
            self$.addOption(private$..plotError)
            self$.addOption(private$..ciWidth)
        }),
    active = list(
        dep = function() private$..dep$value,
        factors = function() private$..factors$value,
        covs = function() private$..covs$value,
        modelTerms = function() private$..modelTerms$value,
        ss = function() private$..ss$value,
        effectSize = function() private$..effectSize$value,
        contrasts = function() private$..contrasts$value,
        plotHAxis = function() private$..plotHAxis$value,
        plotSepLines = function() private$..plotSepLines$value,
        plotSepPlots = function() private$..plotSepPlots$value,
        postHoc = function() private$..postHoc$value,
        postHocCorr = function() private$..postHocCorr$value,
        descStats = function() private$..descStats$value,
        homo = function() private$..homo$value,
        qq = function() private$..qq$value,
        plotError = function() private$..plotError$value,
        ciWidth = function() private$..ciWidth$value),
    private = list(
        ..dep = NA,
        ..factors = NA,
        ..covs = NA,
        ..modelTerms = NA,
        ..ss = NA,
        ..effectSize = NA,
        ..contrasts = NA,
        ..plotHAxis = NA,
        ..plotSepLines = NA,
        ..plotSepPlots = NA,
        ..postHoc = NA,
        ..postHocCorr = NA,
        ..descStats = NA,
        ..homo = NA,
        ..qq = NA,
        ..plotError = NA,
        ..ciWidth = NA)
)

#' @import jmvcore
#' @importFrom R6 R6Class
ancovaResults <- R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        main = function() private$..main,
        assump = function() private$..assump,
        contrasts = function() private$..contrasts,
        postHoc = function() private$..postHoc,
        desc = function() private$..desc,
        descPlot = function() private$..descPlot,
        descPlots = function() private$..descPlots),
    private = list(
        ..main = NA,
        ..assump = NA,
        ..contrasts = NA,
        ..postHoc = NA,
        ..desc = NA,
        ..descPlot = NA,
        ..descPlots = NA),
    public=list(
        initialize=function(options) {
            super$initialize(options=options, name="", title="ANCOVA")
            private$..main <- jmvcore::Table$new(
                options=options,
                name="main",
                title="ANCOVA",
                clearWith=list(
                    "dep",
                    "modelTerms",
                    "ss"),
                columns=list(
                    list(`name`="name", `title`="", `type`="text"),
                    list(`name`="ss", `title`="Sum of Squares", `type`="number"),
                    list(`name`="df", `title`="df", `type`="integer"),
                    list(`name`="ms", `title`="Mean Square", `type`="number"),
                    list(`name`="F", `title`="F", `type`="number"),
                    list(`name`="p", `title`="p", `type`="number", `format`="zto,pvalue"),
                    list(`name`="etaSq", `title`="\u03B7\u00B2", `type`="number", `visible`="(effectSize:eta)", `format`="zto"),
                    list(`name`="etaSqP", `title`="\u03B7\u00B2p", `type`="number", `visible`="(effectSize:partEta)", `format`="zto"),
                    list(`name`="omegaSq", `title`="\u03C9\u00B2", `type`="number", `visible`="(effectSize:omega)", `format`="zto")))
            private$..assump <- R6::R6Class(
                inherit = jmvcore::Group,
                active = list(
                    homo = function() private$..homo,
                    qq = function() private$..qq),
                private = list(
                    ..homo = NA,
                    ..qq = NA),
                public=list(
                    initialize=function(options) {
                        super$initialize(options=options, name="assump", title="Assumption Checks")
                        private$..homo <- jmvcore::Table$new(
                            options=options,
                            name="homo",
                            title="Test for Homogeneity of Variances (Levene's)",
                            visible="(homo)",
                            rows=1,
                            columns=list(
                                list(`name`="F", `type`="number"),
                                list(`name`="df1", `type`="integer"),
                                list(`name`="df2", `type`="integer"),
                                list(`name`="p", `type`="number", `format`="zto,pvalue")))
                        private$..qq <- jmvcore::Image$new(
                            options=options,
                            name="qq",
                            title="Q-Q Plot",
                            visible="(qq)",
                            width=300,
                            height=300,
                            renderFun=".qqPlot",
                            requiresData=TRUE,
                            clearWith=list(
                                "dep",
                                "modelTerms"))
                        self$add(private$..homo)
                        self$add(private$..qq)}))$new(options=options)
            private$..contrasts <- jmvcore::Array$new(
                options=options,
                name="contrasts",
                title="Contrasts",
                visible="(contrasts)",
                clearWith=list(
                    "dep",
                    "modelTerms"),
                template=jmvcore::Table$new(
                    options=options,
                    title="Contrasts - $key",
                    clearWith=NULL,
                    columns=list(
                        list(`name`="contrast", `title`="", `type`="text"),
                        list(`name`="est", `title`="Estimate", `type`="number"),
                        list(`name`="se", `title`="SE", `type`="number"),
                        list(`name`="t", `type`="number"),
                        list(`name`="p", `title`="p", `type`="number", `format`="zto,pvalue"))))
            private$..postHoc <- jmvcore::Array$new(
                options=options,
                name="postHoc",
                title="Post Hoc Tests",
                items="(postHoc)",
                clearWith=list(
                    "dep",
                    "modelTerms"),
                template=jmvcore::Table$new(
                    options=options,
                    title="",
                    columns=list(),
                    clearWith=list(
                        "dep",
                        "modelTerms")))
            private$..desc <- jmvcore::Table$new(
                options=options,
                name="desc",
                title="Descriptives",
                visible="(descStats)",
                clearWith=list(
                    "dep",
                    "modelTerms",
                    "ss"),
                columns=list(
                    list(`name`="n", `title`="N", `type`="integer"),
                    list(`name`="mean", `title`="Mean", `type`="text"),
                    list(`name`="sd", `title`="SD", `type`="number")))
            private$..descPlot <- jmvcore::Image$new(
                options=options,
                name="descPlot",
                title="Descriptive Plot",
                visible="(plotHAxis)",
                width=500,
                height=300,
                renderFun=".descPlot",
                clearWith=list(
                    "plotHAxis",
                    "plotSepLines",
                    "plotSepPlots",
                    "plotError",
                    "ciWidth"))
            private$..descPlots <- jmvcore::Array$new(
                options=options,
                name="descPlots",
                title="Descriptive Plots",
                visible="(plotSepPlots)",
                template=jmvcore::Image$new(
                    options=options,
                    title="$key",
                    renderFun=".descPlot",
                    clearWith=list(
                        "plotHAxis",
                        "plotSepLines",
                        "plotSepPlots",
                        "plotError",
                        "ciWidth")))
            self$add(private$..main)
            self$add(private$..assump)
            self$add(private$..contrasts)
            self$add(private$..postHoc)
            self$add(private$..desc)
            self$add(private$..descPlot)
            self$add(private$..descPlots)}))

#' @importFrom jmvcore Analysis
#' @importFrom R6 R6Class
ancovaBase <- R6::R6Class(
    "ancovaBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'ancova',
                version = c(1,0,0),
                options = options,
                results = ancovaResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = TRUE)
        }))

#' ANCOVA
#'
#' Analysis of Covariance
#'
#' @examples
#' \dontrun{
#' data('ToothGrowth')
#' 
#' ancova(ToothGrowth, dep = 'len', factors = 'supp', covs = 'dose')
#' 
#' #
#' #  ANCOVA
#' #
#' #  ANCOVA
#' #  -----------------------------------------------------------------------
#' #                 Sum of Squares    df    Mean Square    F        p
#' #  -----------------------------------------------------------------------
#' #    supp                    205     1          205.4     11.4     0.001
#' #    dose                   2224     1         2224.3    124.0    < .001
#' #    Residuals              1023    57           17.9
#' #  -----------------------------------------------------------------------
#' #
#' }
#' @param data the data as a data frame
#' @param dep a string naming the dependent variable from \code{data}, 
#'   variable must be numeric 
#' @param factors a vector of strings naming the fixed factors from 
#'   \code{data}
#' @param covs a vector of strings naming the covariates from \code{data}
#' @param modelTerms a list of character vectors describing the terms to go 
#'   into the model 
#' @param ss \code{'1'}, \code{'2'} or \code{'3'} (default), the sum of 
#'   squares to use 
#' @param effectSize one or more of \code{'eta'}, \code{'partEta'}, or 
#'   \code{'omega'}; use eta², partial eta², and omega² effect sizes, 
#'   respectively 
#' @param contrasts a list of lists specifying the factor and type of contrast 
#'   to use, one of \code{'deviation'}, \code{'simple'}, \code{'difference'}, 
#'   \code{'helmert'}, \code{'repeated'} or \code{'polynomial'} 
#' @param plotHAxis a string naming the variable placed on the horizontal axis 
#'   of the plot 
#' @param plotSepLines a string naming the variable represented as separate 
#'   lines on the plot 
#' @param plotSepPlots a string naming the variable to separate over to form 
#'   multiple plots 
#' @param postHoc a list of terms to perform post-hoc tests on
#' @param postHocCorr one or more of \code{'none'}, \code{'tukey'}, 
#'   \code{'scheffe'}, \code{'bonf'}, or \code{'holm'}; provide no, Tukey, 
#'   Scheffe, Bonferroni, and Holm Post Hoc corrections respectively 
#' @param descStats \code{TRUE} or \code{FALSE} (default), provide descriptive 
#'   statistics 
#' @param homo \code{TRUE} or \code{FALSE} (default), perform homogeneity 
#'   tests 
#' @param qq \code{TRUE} or \code{FALSE} (default), provide a Q-Q plot of 
#'   residuals 
#' @param plotError \code{'none'}, \code{'ci'} (default), or \code{'se'}. Use 
#'   no error bars, use confidence intervals, or use standard errors on the 
#'   plots, respectively 
#' @param ciWidth a number between 50 and 99.9 (default: 95) specifying the 
#'   confidence interval width 
#' @export
ancova <- function(
    data,
    dep,
    factors = NULL,
    covs = NULL,
    modelTerms = NULL,
    ss = "3",
    effectSize = NULL,
    contrasts = NULL,
    plotHAxis = NULL,
    plotSepLines = NULL,
    plotSepPlots = NULL,
    postHoc = NULL,
    postHocCorr = list(
                "tukey"),
    descStats = FALSE,
    homo = FALSE,
    qq = FALSE,
    plotError = "ci",
    ciWidth = 95) {

    options <- ancovaOptions$new(
        dep = dep,
        factors = factors,
        covs = covs,
        modelTerms = modelTerms,
        ss = ss,
        effectSize = effectSize,
        contrasts = contrasts,
        plotHAxis = plotHAxis,
        plotSepLines = plotSepLines,
        plotSepPlots = plotSepPlots,
        postHoc = postHoc,
        postHocCorr = postHocCorr,
        descStats = descStats,
        homo = homo,
        qq = qq,
        plotError = plotError,
        ciWidth = ciWidth)

    results <- ancovaResults$new(
        options = options)

    analysis <- ancovaClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
