% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SchurCombination.R
\name{SchurCombination}
\alias{SchurCombination}
\title{Symmetric polynomial in terms of the Schur polynomials}
\usage{
SchurCombination(qspray, check = TRUE)
}
\arguments{
\item{qspray}{a \code{qspray} object defining a symmetric polynomial}

\item{check}{Boolean, whether to check the symmetry of \code{qspray}}
}
\value{
A list defining the combination. Each element of this list is a
  list with two elements: \code{coeff}, a \code{bigq} number, and
  \code{lambda}, an integer partition; then this list corresponds to the
  term \code{coeff * SchurPol(n, lambda)}, where \code{n} is the number of
  variables in the symmetric polynomial.
}
\description{
Expression of a symmetric polynomial as a linear combination
  of some Schur polynomials.
}
\seealso{
\code{\link{JackCombination}}.
}
