% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coala_interface.R
\name{coarsen_jsfs}
\alias{coarsen_jsfs}
\title{Divides the joint site frequency spectrum (jsfs) into blocks
and returns the sum of the jsfs entries for each block.}
\usage{
coarsen_jsfs(ja, part, part_hi = NULL)
}
\arguments{
\item{ja}{an array containing the joint site frequency spectrum}

\item{part}{a vector of integers or a list of vectors of integers. If
it is a list, the vector part[[i]] specifies that the \eqn{i}-th dimension
of \code{ja} should be partitioned into \code{1:(part[[i]][1]-1)},
\code{part[[i]][1]:(part[[i]][2]-1)}, and so on. If \code{part} is a
vector, it will be used for all dimensions.}

\item{part_hi}{NULL or a vector of integers or a list of vector of integers
indicating the partioning at the higher end of each dimension. This means,
if it is a list, the values in the vector \code{dim(ja)[i]-part_hi[[i]]}
will be appended to the end of \code{part[[i]]}. If \code{part_hi} is a
single vector, it will be used for all dimensions. Thus, with the
combination of part=c(1,3) and part_hi=c(1,3), the classical jaatha summary
statistics, plus the two values \code{ja[0]} and
\cite{ja[length(ja)]}. Note that the order in which they appear will
however be different than in the original jaatha summary statistics.}
}
\value{
vector of numbers, which are the sums over the blocks of the jsfs
   for all combinations of partitions
}
\description{
ja is the jsfs, part a list of vectors specifying for each dimension
how ja should be partitioned. If part_hi!=NULL, it is a list spefifying
how ja is to be paritioned on the higher end of each dimension.  if
part or part_hi is not a list, it is turned into a list of the same
length as dim(ja), in which each entry is the original part or part_hi
e.g. 2,7,9 partitions into 1:2, 3:7, 8:9, 9:N For example, with
part=c(1,3) and part_hi=c(1,3) we get the classical jaatha summary
statistics. Note, however, that the order in which they appear will be
different than in the original jaatha package.
}
\references{
A. Tellier, P. Pfaffelhuber, B. Haubold, L. Naduvilezhath,
  L. E. Rose, T. Staedler, W. Stephan, and D. Metzler (2011) Estimating
  parameters of speciation models based on refined summaries of the joint
  site-frequency spectrum. PLoS One 6(5): e18155
}
\author{
Dirk Metzler & Paul Staab
}
