% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialization.R
\name{get_start_pos}
\alias{get_start_pos}
\title{Determine good starting postions}
\usage{
get_start_pos(model, data, reps, sim, init_method, cores, sim_cache,
  block_width, zoom_in_steps = 3)
}
\arguments{
\item{model}{The model used for the estimation. 
See \code{\link{create_jaatha_model}}.}

\item{data}{The data used for the estimation.
See \code{\link{create_jaatha_data}}.}

\item{reps}{The number of independent repetitions.}

\item{sim}{The number of simulations conducted for each step.}

\item{init_method}{Determines how the starting position of each 
repetition is chosen.}

\item{cores}{The number of CPU cores that will be used for the simulations.
The relies on the \pkg{parallel} package, and consequently only one
core is supported on Windows.}

\item{sim_cache}{The simulation cache used in the jaatha analysis}

\item{block_width}{The relative width of a block within jaatha will fit its
local GLM. The default value is usually fine. Increasing this value may 
help in case jaatha fails to converge, while you can try decreasing it if 
the estimates of the likelihoods differ from the corrected values in the 
'Correcting likelihoods for best estimates' phase.}

\item{zoom_in_steps}{The number of steps conducted in the \code{zoom-in}
initialization method. Has no effect if a different initialization method
is used. Using the default value is usually fine.}
}
\value{
The starting positions, as a matrix. Each row corresponds
  to a starting positions.
}
\description{
This is a simple dispatch function returns good starting positions
based on the provided \code{init_method}. The different methods are
explained on \code{\link{jaatha}}.
}
\author{
Paul Staab
}
\keyword{internal}

