% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_jaatha.R
\name{boot_jaatha}
\alias{boot_jaatha}
\title{Parametric Bootstrapping of Jaatha Estimates}
\usage{
boot_jaatha(model, data, results, R, ...)
}
\arguments{
\item{model}{The jaatha model}

\item{data}{The jaatha data}

\item{results}{The results of an \code{\link{jaatha}} analysis performed with 
the same \code{model} and \code{data} as passed to this function.}

\item{R}{The number of bootstrapping replicates that are performed.}

\item{...}{Additional arguments that are passed on \code{\link[boot]{boot}}.
It is highly recommended to use its \code{parallel} and \code{ncpus} 
options to parallelize the bootstrap replicates.}
}
\value{
The result of \code{\link[boot]{boot}}. This object can be used to
  estimate standard errors or confidence intervals of the estimates using
  the functions available in package \pkg{boot}.
}
\description{
This function is a helper function for using the \code{\link[boot]{boot}}
function to bootstrap Jaatha estimates. Each bootstap replication requires
a complete jaatha estimation on data simulated with the original parameter
estimates. Therefore, bootstrapping is normally computationally demanding and
should be executed on a computing cluster. The jaatha analyses are
resticted to a single CPU cores, so that as many replicas as possible can 
be executed in parallel using the corresponding options of 
\code{\link[boot]{boot}}.
}

