\name{dm.addGrowth}
\alias{dm.addGrowth}
\title{Adds an growth or decline of the population size of one
population to a model.}
\usage{
  dm.addGrowth(dm, min.growth.rate, max.growth.rate,
    fixed.growth.rate, par.new = T, new.par.name = "alpha",
    parameter, population, at.time = "0")
}
\arguments{
  \item{dm}{The demographic model to which the size change
  should be added.}

  \item{par.new}{If 'TRUE' a new parameter will be created
  using the arguments 'min.growth.rate' and
  'max.growth.rate' or 'fixed.growth.rate'. It will be
  named 'new.par.name' If 'FALSE' the argument 'parameter'
  will be evaluated instead.}

  \item{min.growth.rate}{If you want to estimate the growth
  rate, this will be used as the smallest possible value.}

  \item{max.growth.rate}{Same as min.growth.rate, but the
  largest possible value.}

  \item{fixed.growth.rate}{If specified, the growth rate
  will not be estimated, but assumed to have the given
  value.}

  \item{new.par.name}{Name for the new parameter.}

  \item{population}{The number of the population in which
  the spilt occurs. See \link{dm.addSpeciationEvent} for
  more information.}

  \item{parameter}{Instead of creating a new parameter, you
  can also set the mutation rate to an expression based on
  existing parameters. For example setting this to "alpha"
  will use an parameter with name tau that you have
  previously created. You can also use R expression here,
  i.e. "2*alpha" or "5*M+2*alpha" (if M is another
  parameter) will also work (also the latter does not make
  much sense).}

  \item{at.time}{The time point at which the size changes.}
}
\value{
  The demographic model with a size change.
}
\description{
  This function changes the growth factor of a population
  at given point in time ('at.time'). This factor than
  applies to the time interval farther into the past from
  this point.
}
\details{
  The population size changes by factor exp(-alpha*t),
  where alpha is the growth parameter and t is the time
  since the growth has started. Hence, for positive alpha,
  the population will 'decline backwards in time' or grow
  forwards in time. Similar, will decline in forwards time
  for a negative value of alpha.

  If you want to add an instantaneous change of the
  population size, then use the \link{dm.addSizeChange}
  function.
}
\examples{
# A model with one smaller population
dm <- dm.createThetaTauModel(c(20,37), 88)
dm <- dm.addGrowth(dm, 0.1, 2, population=2, at.time="0")
}

