% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtr.R
\name{interactSplines}
\alias{interactSplines}
\title{Update splines object with list of interactions}
\usage{
interactSplines(splinesobj, m0, m1, data, uname)
}
\arguments{
\item{splinesobj}{list, consists of two elelments. The first is
\code{removeSplines(m0)}, the second is
\code{removeSplines(m1)}.}

\item{m0}{one-sided formula for the marginal treatment response
function for the control group. This should be the full MTR
specificaiton (i.e. not the specification after removing the
splines).}

\item{m1}{one-sided formula for the marginal treatment response
function for the treated group. This should be the full MTR
specificaiton (i.e. not the specification after removing the
splines).}

\item{data}{data.frame, restricted to complete observations.}

\item{uname}{string, name of the unobserved variable.}
}
\value{
An updated version of \code{splinesobj}.
}
\description{
Certain interactions between factor variables and splines should be
dropped to avoid collinearity. Albeit collinearity in the MTR
specification will not impact the bounds, it can substantially
impact how costly it is to carry out the estimation. What this
function does is map each spline to a temporary variable. A design
matrix is then constructed using these temporary variables in place
the splines. If an interaction involving one of the temporary
variables is dropped, then one knows to also drop the corresponding
interaction with the spline. Note that only interaction terms need
to be omitted, so one does not need to worry about the formula
contained in removeSplines$formula.
}
