% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.VariableAnalysis}
\alias{plot.VariableAnalysis}
\title{Display variable importance.}
\usage{
\method{plot}{VariableAnalysis}(x, ...)
}
\arguments{
\item{x}{(\code{VariableAnalysis}) The variable importance object to plot.
It could be the return of function \code{\link{variable_analysis}}.}

\item{...}{Not used.}
}
\value{
A \code{patchwork} of \code{ggplot2} figure of variable importance
according to multiple metrics.
}
\description{
Display informative and detailed figures of variable importance.
}
\examples{
\donttest{
# Using a pseudo presence-only occurrence dataset of
# virtual species provided in this package
library(dplyr)
library(sf)
library(stars)
library(itsdm)

# Prepare data
data("occ_virtual_species")
obs_df <- occ_virtual_species \%>\% filter(usage == "train")
eval_df <- occ_virtual_species \%>\% filter(usage == "eval")
x_col <- "x"
y_col <- "y"
obs_col <- "observation"

# Format the observations
obs_train_eval <- format_observation(
  obs_df = obs_df, eval_df = eval_df,
  x_col = x_col, y_col = y_col, obs_col = obs_col,
  obs_type = "presence_only")

env_vars <- system.file(
  'extdata/bioclim_tanzania_10min.tif',
  package = 'itsdm') \%>\% read_stars() \%>\%
  slice('band', c(1, 5, 12, 16))

# With imperfect_presence mode,
mod <- isotree_po(
  obs_mode = "imperfect_presence",
  obs = obs_train_eval$obs,
  obs_ind_eval = obs_train_eval$eval,
  variables = env_vars, ntrees = 20,
  sample_size = 0.8, ndim = 2L,
  seed = 123L, response = FALSE,
  spatial_response = FALSE,
  check_variable = FALSE)

var_analysis <- variable_analysis(
  model = mod$model,
  pts_occ = mod$observation,
  pts_occ_test = mod$independent_test,
  variables = mod$variables)
plot(var_analysis)
}

}
\seealso{
\code{\link{variable_analysis}}, \code{\link{print.VariableAnalysis}}
}
