% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.PAConversion}
\alias{plot.PAConversion}
\title{Display results of conversion to presence-absence (PA).}
\usage{
\method{plot}{PAConversion}(x, ...)
}
\arguments{
\item{x}{(\code{PAConversion}) The \code{PAConversion} object to plot.
It could be the return of function \code{\link{convert_to_pa}}.}

\item{...}{Not used.}
}
\value{
A \code{patchwork} of \code{ggplot2} figure of suitability, probability of occurrence,
presence-absence binary map.
}
\description{
Display raster of suitability, probability of occurrence,
presence-absence binary map from presence-absence (PA) conversion.
}
\examples{
\donttest{
# Using a pseudo presence-only occurrence dataset of
# virtual species provided in this package
library(dplyr)
library(sf)
library(stars)
library(itsdm)

# Prepare data
data("occ_virtual_species")
obs_df <- occ_virtual_species \%>\% filter(usage == "train")
eval_df <- occ_virtual_species \%>\% filter(usage == "eval")
x_col <- "x"
y_col <- "y"
obs_col <- "observation"

# Format the observations
obs_train_eval <- format_observation(
  obs_df = obs_df, eval_df = eval_df,
  x_col = x_col, y_col = y_col, obs_col = obs_col,
  obs_type = "presence_only")

env_vars <- system.file(
  'extdata/bioclim_tanzania_10min.tif',
  package = 'itsdm') \%>\% read_stars() \%>\%
  slice('band', c(1, 5, 12, 16))

# With imperfect_presence mode,
mod <- isotree_po(
  obs_mode = "imperfect_presence",
  obs = obs_train_eval$obs,
  obs_ind_eval = obs_train_eval$eval,
  variables = env_vars, ntrees = 20,
  sample_size = 0.8, ndim = 2L,
  seed = 123L, response = FALSE,
  spatial_response = FALSE,
  check_variable = FALSE)

# Threshold conversion
pa_thred <- convert_to_pa(mod$prediction,
  method = 'threshold', beta = 0.5)
plot(pa_thred)
}

}
\seealso{
\code{\link{convert_to_pa}}, \code{\link{print.PAConversion}}
}
