% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{group_sort}
\alias{group_sort}
\title{Sort split by grouping predictor.}
\usage{
group_sort(x, group = NULL, decreasing = FALSE)
}
\arguments{
\item{x}{A vector to be sorted.}

\item{group}{A names list that specify the different groups to split the 
data.}

\item{decreasing}{Logical: whether or not the sort order should be 
decreasing.}
}
\value{
Indices indicating the order of vector x per group.
}
\description{
Function uses \code{\link[base]{sort.list}} to return indices
of of a vector, sorted per group.
}
\examples{
data(simdat)
range(simdat$Y)
ind <- group_sort(simdat$Y, 
    group=list(Group=simdat$Group, Trial=simdat$Trial))
head(simdat[ind,])
}
\author{
Jacolien van Rij
}
\seealso{
\code{\link[base]{sort.list}}

Other Utility functions: \code{\link{convertNonAlphanumeric}},
  \code{\link{diff_terms}}, \code{\link{findAbsMin}},
  \code{\link{find_difference}},
  \code{\link{find_n_neighbors}}, \code{\link{getDec}},
  \code{\link{getRange}}, \code{\link{list2str}},
  \code{\link{missing_est}}, \code{\link{move_n_point}},
  \code{\link{print_summary}}, \code{\link{se}},
  \code{\link{summary_data}}, \code{\link{timeBins}}
}

