% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isnigls.R
\name{fun.glssubi}
\alias{fun.glssubi}
\title{Internal Function for various subject-level computation required for ISNIGLS.}
\usage{
fun.glssubi(yi, xi, maxT = maxT, b, D, ycorr, transform = FALSE,
  gfiti = NULL, Afiti = NULL, case = 1)
}
\arguments{
\item{yi}{vector of the response for the ith subject}

\item{xi}{matrix of the covariates for the ith subject}

\item{maxT}{maximum number of visits}

\item{b}{the mean parameter vector beta}

\item{D}{the vector of unique parameters in the variance-covariance matrix for the error term in the GLS model for Y}

\item{ycorr}{the form of within-subject correlation structure in the GLS model for Y}

\item{transform}{logical indicating wether or not the parameter in D is transformed.}

\item{gfiti}{vector of predicted probabilities of being observed for all the observations from the ith subject}

\item{Afiti}{matrix of 3 columns of predicted transitional probabilities for the missing observations from the ith subject.}

\item{case}{1: calculated nabla11_i; 2: calculate nabla12_i}
}
\description{
Calculate subject-level quantities when the regression outcome is subject to missingness and follows generalized least sqaures models (GLS)
}
