% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_IRT.R
\name{plot.Itempool}
\alias{plot.Itempool}
\title{Plot Item Characteristic Curves or Test Characteristic Curve of an
\code{Itempool} object}
\usage{
\method{plot}{Itempool}(
  x,
  theta_range = c(-4, 4),
  tcc = FALSE,
  tcc_prop_corr = FALSE,
  title = "",
  suppress_plot = FALSE,
  legend_title = NULL,
  ...
)
}
\arguments{
\item{x}{An \code{\link{Itempool-class}} object.}

\item{theta_range}{The boundaries of x axis.}

\item{tcc}{If \code{TRUE} a test characteristic curve will be plotted.}

\item{tcc_prop_corr}{If \code{TRUE}, test characteristic curve will be
show the proportion correct of the test (i.e. the range of y-axis
will be 0-1 instead of 0 to the number of items).}

\item{title}{Title of the plot. Default is \code{NULL}. If \code{tcc} is
\code{TRUE} it will be 'Test Characteristic Curve', if \code{FALSE}
it will be 'Item Characteristic Curve'.}

\item{suppress_plot}{If \code{FALSE} the function will print the plot. If
\code{TRUE}, function will return the plot object. Default value is
\code{FALSE}.}

\item{legend_title}{The title of the plot's legend.}

\item{...}{Additional arguments that will be passed to \code{geom_line}}
}
\value{
Depending on the value of \code{suppress_plot} function either prints
the item characteristic curve or returns the plot object.
}
\description{
\code{plot.Itempool} plots the item characteristic curves (item response
curves) or test characteristic curve of an \code{\link{Itempool-class}} object.
}
\examples{
n <- sample(10:15,1)
ip <- itempool(a = runif(n, .5, 2), b = rnorm(n), c = runif(n, 0, .3), D = 1)
plot(ip)
# Additional arguments will passed to geom_line
plot(ip, size = .25, alpha = 0.3)
# Test Characteristic Curve
plot(ip, tcc = TRUE)
# Proportion correct for test characteristic curve
plot(ip, tcc = TRUE, tcc_prop_corr = TRUE)
# # Remove the legend altogether
# plot(ip, suppress_plot = TRUE) + theme(legend.position="none")
# # Change the labels:
# plot(ip, suppress_plot = TRUE) + ylab("Probability") + xlab("Ability Score")
}
\author{
Emre Gonulates
}
