% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ops.R
\name{ir_add}
\alias{ir_add}
\title{Add infrared spectra}
\usage{
ir_add(x, y)
}
\arguments{
\item{x}{An object of class \code{\link[=ir_new_ir]{ir}}.}

\item{y}{An object of class \code{\link[=ir_new_ir]{ir}} or a numeic value. If \code{y}
is an object of class \code{ir}, it must have the same number of rows as
\code{x} and the same x axis values (e.g. wavenumber values) in each matching
spectrum as in \code{x}.}
}
\value{
\code{x} where for each spectrum the respective intensity values in
\code{y} are added.
}
\description{
\code{ir_add} takes two objects of class \code{ir}, \code{x} and
\code{y}, and adds the intensity values of spectra in matching rows from
\code{y} to that of \code{x}.
}
\examples{
x1 <-
  ir::ir_add(ir::ir_sample_data, ir::ir_sample_data)
x1 <-
  ir::ir_add(ir::ir_sample_data, ir::ir_sample_data[1, ])

}
