% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_define_extract.R
\name{add_to_extract.nhgis_extract}
\alias{add_to_extract.nhgis_extract}
\title{Add values to an existing IPUMS NHGIS extract definition}
\usage{
\method{add_to_extract}{nhgis_extract}(
  extract,
  description = NULL,
  datasets = NULL,
  time_series_tables = NULL,
  geographic_extents = NULL,
  shapefiles = NULL,
  breakdown_and_data_type_layout = NULL,
  tst_layout = NULL,
  data_format = NULL,
  ...
)
}
\arguments{
\item{extract}{An \code{\link[=ipums_extract-class]{ipums_extract}} object.}

\item{description}{Description of the extract.}

\item{datasets}{List of \code{ds_spec} objects created by \code{\link[=ds_spec]{ds_spec()}}
containing the specifications
for the \href{https://www.nhgis.org/overview-nhgis-datasets}{datasets}
to include in the extract request. See examples.

If a dataset already exists in the extract, its new specifications
will be added to those that already exist for that dataset.}

\item{time_series_tables}{List of \code{tst_spec} objects created by \code{\link[=tst_spec]{tst_spec()}}
containing the specifications for the
\href{https://www.nhgis.org/time-series-tables}{time series tables}
to include in the extract request.

If a time series table already exists in the extract, its new
specifications will be added to those that already exist for that time
series table.}

\item{geographic_extents}{Vector of geographic extents to use for
all of the \code{datasets} in the extract definition (for instance, to obtain
data within a particular state). Use \code{"*"} to select all available extents.

Required when any of the \code{datasets} included in the extract definition
include \code{geog_levels} that require extent selection. See
\code{\link[=get_metadata_nhgis]{get_metadata_nhgis()}} to determine if a geographic level requires extent
selection. At the time of writing, NHGIS supports extent selection only
for blocks and block groups.}

\item{shapefiles}{Names of any \href{https://www.nhgis.org/gis-files}{shapefiles}
to include in the extract request.}

\item{breakdown_and_data_type_layout}{The desired layout
of any \code{datasets} that have multiple data types or breakdown values.
\itemize{
\item \code{"single_file"} (default) keeps all data types and breakdown values in
one file
\item \code{"separate_files"} splits each data type or breakdown value into its
own file
}

Required if any \code{datasets} included in the extract definition consist of
multiple data types (for instance, estimates and margins of error) or have
multiple breakdown values specified. See \code{\link[=get_metadata_nhgis]{get_metadata_nhgis()}} to
determine whether a requested dataset has multiple data types.}

\item{tst_layout}{The desired layout of all \code{time_series_tables} included in
the extract definition.
\itemize{
\item \code{"time_by_column_layout"} (wide format, default): rows correspond to
geographic units, columns correspond to different times in the time
series
\item \code{"time_by_row_layout"} (long format): rows correspond to a single
geographic unit at a single point in time
\item \code{"time_by_file_layout"}: data for different times are provided in
separate files
}

Required when an extract definition includes any \code{time_series_tables}.}

\item{data_format}{The desired format of the extract data file.
\itemize{
\item \code{"csv_no_header"} (default) includes only a minimal header in the first
row
\item \code{"csv_header"} includes a second, more descriptive header row.
\item \code{"fixed_width"} provides data in a fixed width format
}

Note that by default, \code{\link[=read_nhgis]{read_nhgis()}} removes the additional header row in
\code{"csv_header"} files.

Required when an extract definition includes any \code{datasets} or
\code{time_series_tables}.}

\item{...}{Ignored}
}
\value{
A modified \code{nhgis_extract} object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Add new values to an IPUMS NHGIS extract definition.
All fields are optional, and if omitted, will be unchanged.
Supplying a value for fields that take a single value, such as
\code{description} and \code{data_format}, will replace the existing value with
the supplied value.

This function is marked as experimental because it is typically not the best
option for maintaining reproducible extract definitions and may be retired
in the future. For reproducibility, users should strive to build extract
definitions with \code{\link[=define_extract_nhgis]{define_extract_nhgis()}}.

If you have a complicated extract definition to revise, but do not have
the original extract definition code that created it, we suggest that you
save the revised extract as a JSON file with \code{\link[=save_extract_as_json]{save_extract_as_json()}}. This
will create a stable version of the extract definition that
can be used in the future as needed.

To remove existing values from an IPUMS NHGIS extract definition, use
\code{\link[=remove_from_extract.nhgis_extract]{remove_from_extract()}}.

Learn more about the IPUMS API in \code{vignette("ipums-api")}.
}
\details{
For extract fields that take a single value, \code{add_to_extract()} will
replace the existing value with the new value provided for that field.
It is not necessary to first remove this value using
\code{remove_from_extract()}.

If the supplied extract definition comes from
a previously submitted extract request, this function will reset the
definition to an unsubmitted state.
}
\examples{
extract <- define_extract_nhgis(
  datasets = ds_spec("1990_STF1", c("NP1", "NP2"), "county")
)

# Add a new dataset or time series table to the extract
add_to_extract(
  extract,
  datasets = ds_spec("1990_STF2a", "NPA1", "county")
)

add_to_extract(
  extract,
  time_series_tables = tst_spec("A00", "state")
)

# If a dataset/time series table name already exists in the definition
# its specification will be modified by adding the new specifications to
# the existing ones
add_to_extract(
  extract,
  datasets = ds_spec("1990_STF1", "NP4", "nation")
)

# You can add new datasets and modify existing ones simultaneously by
# providing a list of `ds_spec` objects
add_to_extract(
  extract,
  datasets = list(
    ds_spec("1990_STF1", "NP4", "nation"),
    ds_spec("1990_STF2a", "NPA1", "county")
  )
)

# Values that can only take a single value are replaced
add_to_extract(extract, data_format = "fixed_width")$data_format
}
\seealso{
\code{\link[=remove_from_extract.nhgis_extract]{remove_from_extract()}} to remove
values from an extract definition.

\code{\link[=define_extract_nhgis]{define_extract_nhgis()}} to create a new extract definition.

\code{\link[=submit_extract]{submit_extract()}} and \code{\link[=download_extract]{download_extract()}} to submit and process an
extract request.
}
\keyword{internal}
