% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terra_read.r
\name{read_terra_micro}
\alias{read_terra_micro}
\title{Read data from an IPUMS Terra microdata extract}
\usage{
read_terra_micro(
  data_file,
  ddi_file = NULL,
  data_layer = NULL,
  n_max = Inf,
  verbose = TRUE,
  var_attrs = c("val_labels", "var_label", "var_desc")
)
}
\arguments{
\item{data_file}{Path to the data file, which can either be the .zip file directly
downloaded from the IPUMS Terra website, a path to the unzipped version of that
folder, or to the csv unzipped from the download.}

\item{ddi_file}{(Optional) If the download is unzipped, path to the .xml file which
provides usage and citation information for extract.}

\item{data_layer}{For .zip extracts with multiple datasets, the name of the
 data to load. Accepts a character vector specifying the file name, or
\code{\link{dplyr_select_style}} conventions. Data layer must uniquely identify
a dataset.}

\item{n_max}{Maximum number of observations to read from the data}

\item{verbose}{Logical, indicating whether to print progress information
to console.}

\item{var_attrs}{Variable attributes to add from the DDI, defaults to
adding all (val_labels, var_label and var_desc). See
\code{\link{set_ipums_var_attributes}} for more details.}
}
\value{
\code{read_terra_micro} returns a \code{tbl_df} with the tabular data. Use
  \code{\link{read_ipums_sf}} or \code{\link{read_ipums_sp}} to read shape
  data out of a microdata Terra extract.
}
\description{
Reads a microdata dataset downloaded from the IPUMS Terra extract system.
}
\examples{
\dontrun{
data <- read_terra_micro("2553_bundle.zip")
}
}
\seealso{
Other ipums_read: 
\code{\link{read_ipums_micro_chunked}()},
\code{\link{read_ipums_micro_yield}()},
\code{\link{read_ipums_micro}()},
\code{\link{read_ipums_sf}()},
\code{\link{read_nhgis}()},
\code{\link{read_terra_area}()},
\code{\link{read_terra_raster}()}
}
\concept{ipums_read}
