% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datafiles.R
\docType{data}
\name{ffood}
\alias{ffood}
\title{Service (waiting) times (in seconds)  of customers at a fast-food 
restaurant.}
\format{
An object of class \code{data.frame} with 10 rows and 2 columns.
}
\usage{
ffood
}
\description{
@format A data frame with 10 rows and 2 columns:
\describe{
  \item{AM}{Waiting times for customers served during 9-10AM}
  \item{PM}{Waiting times for customers served during 2-3PM}
}
}
\examples{
 summary(ffood)
 # 95\% Confidence interval for the mean waiting time usig t-distribution
 a <- c(ffood$AM, ffood$PM)
 mean(a) + c(-1, 1) * qt(0.975, df=19) * sqrt(var(a))/sqrt(20) 
 # Two sample t-test for the difference between morning and afternoon times
 t.test(ffood$AM, ffood$PM)
}
\keyword{datasets}
