% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/long_to_wide_converter.R
\name{long_to_wide_converter}
\alias{long_to_wide_converter}
\title{Converts dataframe from long/tidy to wide format with \code{NA}s removed}
\usage{
long_to_wide_converter(
  data,
  x,
  y,
  subject.id = NULL,
  paired = TRUE,
  spread = TRUE,
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. Other data types (e.g., matrix,table, array, etc.) will \strong{not}
be accepted.}

\item{x}{The grouping (or independent) variable from the dataframe \code{data}. In
case of a repeated measures or within-subjects design, if \code{subject.id}
argument is not available or not explicitly specified, the function assumes
that the data has already been sorted by such an id by the user and creates
an internal identifier. So if your data is \strong{not} sorted, the results
\emph{can} be inaccurate when there are more than two levels in \code{x} and there
are \code{NA}s present. The data is expected to be sorted by user in
subject-1,subject-2, ..., pattern.}

\item{y}{The response (or outcome or dependent) variable from the
dataframe \code{data}.}

\item{subject.id}{Relevant in case of a repeated measures or within-subjects
design (\code{paired = TRUE}, i.e.), it specifies the subject or repeated
measures identifier. \strong{Important}: Note that if this argument is \code{NULL}
(which is the default), the function assumes that the data has already been
sorted by such an id by the user and creates an internal identifier. So if
your data is \strong{not} sorted and you leave this argument unspecified, the
results \emph{can} be inaccurate when there are more than two levels in \code{x} and
there are \code{NA}s present.}

\item{paired}{Logical that decides whether the experimental design is
repeated measures/within-subjects or between-subjects. The default is
\code{FALSE}.}

\item{spread}{Logical that decides whether the dataframe needs to be
converted from long/tidy to wide (default: \code{TRUE}). Relevant only if
\code{paired = TRUE}.}

\item{...}{Currently ignored.}
}
\value{
A dataframe with \code{NA}s removed.
}
\description{
This conversion is helpful mostly for repeated measures design, where
removing \code{NA}s by participant can be a bit tedious.

It does not make sense to spread the dataframe to wide format when the
measure is not repeated, so if \code{paired = TRUE}, \code{spread} argument will be
ignored.
}
\examples{
# for reproducibility
library(ipmisc)
set.seed(123)

# repeated measures design
long_to_wide_converter(
  data = bugs_long,
  x = condition,
  y = desire,
  subject.id = subject,
  paired = TRUE
)

# independent measures design (spread argument is ignored)
long_to_wide_converter(
  data = ggplot2::msleep,
  x = vore,
  y = brainwt,
  paired = FALSE,
  spread = FALSE
)
}
