% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_messages.R
\name{normality_message}
\alias{normality_message}
\title{Display normality test result as a message.}
\usage{
normality_message(x, lab = NULL, k = 2, ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{lab}{A character describing label for the variable. If \code{NULL}, a
generic \code{"x"} label will be used.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 3}).}

\item{...}{Additional arguments (ignored).}
}
\value{
A list with class \code{"htest"} containing the following components:
  \item{statistic}{the value of the Shapiro-Wilk statistic.}
  \item{p.value}{an approximate p-value for the test.  This is
    said in Royston (1995) to be adequate for \code{p.value < 0.1}.}
  \item{method}{the character string \code{"Shapiro-Wilk normality test"}.}
  \item{data.name}{a character string giving the name(s) of the data.}
}
\description{
A note to the user about the validity of assumptions for the
default linear model.
}
\examples{
# message
normality_message(
  x = anscombe$x1,
  lab = "x1",
  k = 3
)
}
