/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.toolkit;

import org.rosuda.ibase.Notifier;
import org.rosuda.ibase.NotifyMsg;
import org.rosuda.ibase.SCatSequence;
import org.rosuda.ibase.SVar;
import org.rosuda.ibase.toolkit.AxisCatSequence;
import org.rosuda.util.Global;
import org.rosuda.util.Tools;

public class Axis
extends Notifier {
    private static final double PRECISION = 1.0E-4;
    public static final int O_Horiz = 0;
    public static final int O_Vert = 1;
    public static final int O_X = 0;
    public static final int O_Y = 1;
    public static final int T_Num = 0;
    public static final int T_EqCat = 1;
    public static final int T_PropCat = 2;
    public static final int T_EqSize = 3;
    SVar v;
    int or;
    public int gBegin;
    public int gLen;
    public double vBegin;
    public double vLen;
    public int datacount;
    int gInterSpc = 0;
    double vLenLog10;
    int type;
    int gap = 0;
    SCatSequence seq;
    AxisCatSequence seqgeom;
    public int trl = 0;
    public boolean drawAxis = false;

    public Axis(SVar sVar) {
        this.v = sVar;
        this.or = 0;
        this.gInterSpc = 0;
        this.type = 3;
        if (this.v != null) {
            if (this.v.isNum()) {
                this.type = 0;
            }
            if (this.v.isCat()) {
                this.type = 2;
            }
            this.seq = this.v.linked ? this.v.mainSeq() : new SCatSequence(this.v, this, false);
            this.seqgeom = new AxisCatSequence(this, this.seq);
        }
        this.setDefaultRange();
    }

    public Axis(SVar sVar, int n, int n2) {
        this.v = sVar;
        this.type = n2;
        this.or = n;
        this.gInterSpc = 0;
        if (this.v != null) {
            this.seq = this.v.linked ? this.v.mainSeq() : new SCatSequence(this.v, this, false);
            this.seqgeom = new AxisCatSequence(this, this.seq);
        }
        this.setDefaultRange();
    }

    public int getOrientation() {
        return this.or;
    }

    public void setType(int n) {
        if (n == this.type) {
            return;
        }
        boolean bl = true;
        if (n == 1 && this.type == 2 || n == 2 && this.type == 1) {
            bl = false;
        }
        this.type = n;
        this.setDefaultRange(bl);
    }

    public int getType() {
        return this.type;
    }

    public void setGeometry(int n, int n2, int n3) {
        if (n != this.or || n2 != this.gBegin || n3 != this.gLen) {
            this.gBegin = n2;
            this.gLen = n3;
            this.or = n;
            this.NotifyAll(new NotifyMsg(this, 8192));
        }
    }

    public boolean setValueRange(double d, double d2) {
        if (Global.DEBUG > 0) {
            System.out.println("Axis.setValueRange(" + d + "," + d2 + ")");
        }
        if (Math.abs(this.vBegin - d) > 1.0E-4 || Math.abs(this.vLen - d2) > 1.0E-4) {
            this.vBegin = d;
            this.vLen = d2;
            this.vLenLog10 = Math.abs(this.vLen) < 1.0E-4 ? 0.0 : Math.log(this.vLen < 0.0 ? -this.vLen : this.vLen) / Math.log(10.0);
            this.NotifyAll(new NotifyMsg(this, 8192));
            return true;
        }
        return false;
    }

    public boolean setValueRange(double[] dArray) {
        if (Global.DEBUG > 0) {
            System.out.println("Axis.setValueRange(double[2])");
        }
        if (dArray == null || dArray.length != 2) {
            return false;
        }
        return this.setValueRange(dArray[0], dArray[1]);
    }

    public boolean setValueRange(int n) {
        if (Global.DEBUG > 0) {
            System.out.println("Axis.setValueRange(" + n + ")");
        }
        if (n < 1) {
            n = 1;
        }
        if (n != this.datacount) {
            this.datacount = n;
            this.vBegin = 0.0;
            this.vLen = n;
            this.vLenLog10 = Math.abs(this.vLen) < 1.0E-4 ? 0.0 : Math.log(this.vLen) / Math.log(10.0);
            this.NotifyAll(new NotifyMsg(this, 8192));
            return true;
        }
        return false;
    }

    public void setDefaultRange() {
        this.setDefaultRange(true);
    }

    public void setDefaultRange(boolean bl) {
        if (this.v == null) {
            this.vBegin = 0.0;
            this.vLen = 1.0;
            return;
        }
        if (this.v.isNum() && this.type == 0) {
            this.vBegin = this.v.getMin();
            this.vLen = this.v.getMax() - this.vBegin;
            this.vLenLog10 = Math.abs(this.vLen) < 1.0E-4 ? 0.0 : Math.log(this.vLen < 0.0 ? -this.vLen : this.vLen) / Math.log(10.0);
        } else {
            this.datacount = this.v.size();
            this.vBegin = 0.0;
            this.vLen = this.datacount;
            double d = this.vLenLog10 = Math.abs(this.vLen) < 1.0E-4 ? 0.0 : Math.log(this.vLen) / Math.log(10.0);
        }
        if (this.v.isCat() && this.type == 1) {
            this.datacount = this.v.getNumCats();
            this.vBegin = 0.0;
            this.vLen = this.datacount;
            double d = this.vLenLog10 = Math.abs(this.vLen) < 1.0E-4 ? 0.0 : Math.log(this.vLen) / Math.log(10.0);
        }
        if ((this.type == 2 || this.type == 1) && bl) {
            this.seq.reset();
        }
        this.NotifyAll(new NotifyMsg(this, 8192));
    }

    public SVar getVariable() {
        return this.v;
    }

    public void setVariable(SVar sVar) {
        this.v = sVar;
    }

    public int getCasePos(int n) {
        if (this.type == 3) {
            return this.gBegin + (int)((double)this.gLen / (double)this.datacount * (double)n);
        }
        if (this.type == 0) {
            return this.gBegin + (int)((double)this.gLen * (this.v.atF(n) - this.vBegin) / this.vLen);
        }
        if (this.type == 2 || this.type == 1) {
            return this.getCatCenter(this.v.getCatIndex(n));
        }
        return -1;
    }

    public int getValuePos(double d) {
        if (this.type == 3) {
            return this.gBegin + (int)((double)this.gLen / (double)this.datacount * d);
        }
        if (this.type == 0) {
            return this.gBegin + (int)((double)this.gLen * (d - this.vBegin) / this.vLen);
        }
        if (this.type == 2 || this.type == 1) {
            return this.getCatCenter((int)(d + 0.5));
        }
        return -1;
    }

    public double getValueForPos(int n) {
        if (this.type == 3) {
            return (double)((n - this.gBegin) * this.datacount) / (double)this.gLen;
        }
        if (this.type == 0) {
            return this.vBegin + (double)(n - this.gBegin) * this.vLen / (double)this.gLen;
        }
        return -1.0;
    }

    public int clip(int n) {
        return this.gLen < 0 ? (n > this.gBegin ? this.gBegin : (n < this.gBegin + this.gLen ? this.gBegin + this.gLen : n)) : (n < this.gBegin ? this.gBegin : (n > this.gBegin + this.gLen ? this.gBegin + this.gLen : n));
    }

    public int getCatLow(int n) {
        return this.seqgeom.getLowerEdgeOfCat(n);
    }

    public int getCatUp(int n) {
        return this.seqgeom.getUpperEdgeOfCat(n);
    }

    public int getCatCenter(int n) {
        return this.seqgeom.getCenterOfCat(n);
    }

    public int getRegularCatPos(int n, int n2, int n3) {
        return this.gBegin + n2 + this.getCatSeqIndex(n) * (this.gLen - n2 - n3) / (this.v.getNumCats() - 1);
    }

    public int getCatByPos(int n) {
        return this.seqgeom.getCatByGeometryPos(n);
    }

    public boolean swapCats(int n, int n2) {
        return this.seq.swapCats(n, n2);
    }

    public boolean moveCat(int n, int n2) {
        int n3;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= (n3 = this.v.getNumCats())) {
            n2 = n3 - 1;
        }
        return this.seq.moveCatAtPosTo(this.seq.posOfCat(n), n2);
    }

    public int getCatSeqIndex(int n) {
        return this.seq.posOfCat(n);
    }

    public int getCatAtSeqIndex(int n) {
        return this.seq.catAtPos(n);
    }

    public double getSensibleTickDistance(int n, int n2) {
        double d = this.gLen < 0 ? (double)(-this.gLen) : (double)this.gLen;
        double d2 = this.vLen < 0.0 ? -this.vLen : this.vLen;
        double d3 = Math.pow(10.0, Math.round(Math.log(d2 * (double)n / d) / Math.log(10.0)));
        if (n2 < 1) {
            return d3;
        }
        int n3 = (int)(d3 / d2 * d);
        if (Global.DEBUG > 0) {
            System.out.println("Axis.getSensibleTickDistance(" + n + "," + n2 + "): grs=" + n3 + ", preld=" + d3);
        }
        while (n3 > 2 * n) {
            n3 /= 2;
            d3 /= 2.0;
        }
        if (n3 < n2 / 3) {
            d3 *= 5.0;
        } else if (n3 < n2) {
            d3 *= 2.0;
        }
        if ((this.type == 1 || this.type == 2) && d3 < 1.0) {
            return 1.0;
        }
        return d3;
    }

    public double getSensibleTickStart(double d) {
        if (this.type == 1 || this.type == 2) {
            return 0.0;
        }
        double d2 = d * (double)((int)(this.vBegin / d));
        if (d2 < this.vBegin) {
            d2 += d;
        }
        return d2;
    }

    public String getDisplayableValue(double d) {
        int n = 2 - (int)this.vLenLog10 < 0 ? 0 : 2 - (int)this.vLenLog10;
        return Tools.getDisplayableValue(d, n);
    }

    public double[] getValueRange() {
        double[] dArray = new double[]{this.vBegin, this.vBegin + this.vLen};
        return dArray;
    }

    public void setOrthTrans(int n) {
        this.trl = n;
    }

    public String toString() {
        return "Axis(type=" + this.type + ",or=" + this.or + ",g[" + this.gBegin + ":" + this.gLen + "],v[" + this.vBegin + ":" + this.vLen + "],trl=" + this.trl + ",draw=" + this.drawAxis + ",dc=" + this.datacount + (this.seq != null ? ",seq=" + this.seq.toString() + ")" : ")");
    }
}

