/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.WindowListener;
import org.rosuda.ibase.Notifier;
import org.rosuda.ibase.toolkit.WinListener;
import org.rosuda.plugins.PluginManager;
import org.rosuda.util.Global;
import org.rosuda.util.GlobalConfig;
import org.rosuda.util.Platform;
import org.rosuda.util.Tools;

public class Common {
    public static String Version = "1.0-7";
    public static String Release = "D729";
    public static String appName = "default";
    public static boolean useSwing = true;
    public static boolean startRserv = false;
    public static final int AT_KOH = 32;
    public static final int AT_Framework = 48;
    static StringBuffer warnings = null;
    static int warningsCount = 0;
    static int maxWarnings = 250;
    public static Dimension screenRes = null;
    public static Color backgroundColor = new Color(255, 255, 192);
    public static Color popupColor = new Color(245, 255, 255);
    public static Color aquaBgColor = new Color(230, 230, 240);
    public static Color selectColor = new Color(255, 0, 0);
    public static Color objectsColor = new Color(255, 255, 255);
    public static boolean noIntVar = false;
    public static Font defaultFont = new Font("SansSerif", 0, 10);
    public static final int NM_MarkerChange = 4096;
    public static final int NM_SecMarkerChange = 4098;
    public static final int NM_AxisChange = 8192;
    public static final int NM_AxisGeometryChange = 8193;
    public static final int NM_AxisDataChange = 8194;
    public static final int NM_VarChange = 12288;
    public static final int NM_VarContentChange = 12289;
    public static final int NM_VarTypeChange = 12290;
    public static final int NM_VarSeqChange = 12291;
    public static final int NM_VarSetChange = 16384;
    public static final int NM_NodeChange = 20480;
    public static final int NM_CatSeqChange = 24576;
    public static final int NM_PrefsChanged = 28672;
    public static final int NM_BREAK = 0x700000;
    public static final int NM_ExtEvent = 0x800000;
    public static final int NM_ActionEvent = 0x800001;
    public static final int NM_MASK = 0xFFF000;
    public static boolean supportsBREAK = false;
    public static Notifier breakDispatcher = null;
    public static Cursor cur_arrow;
    public static Cursor cur_query;
    public static Cursor cur_tick;
    public static Cursor cur_hand;
    public static Cursor cur_zoom;
    public static Cursor cur_move;
    public static Cursor cur_aim;
    public static Frame mainFrame;
    static WindowListener defWinListener;
    static Frame workFrame;
    public static double displayGamma;

    public static WindowListener getDefaultWindowListener() {
        if (defWinListener == null) {
            defWinListener = new WinListener();
        }
        return defWinListener;
    }

    public static void initValuesFromConfigFile(PluginManager pluginManager) {
        int n;
        if (Global.DEBUG > 0) {
            System.out.println("Common.initValuesFromConfigFile: loading values");
        }
        String string = GlobalConfig.getS("Common.color.background");
        if (Global.DEBUG > 0) {
            System.out.println("Common.color.background=" + string);
        }
        if (string != null && string.length() > 0 && string.charAt(0) == '#') {
            n = Tools.parseHexInt(string.substring(1));
            backgroundColor = new Color(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
        }
        string = GlobalConfig.getS("Common.color.select");
        if (Global.DEBUG > 0) {
            System.out.println("Common.color.select=" + string);
        }
        if (string != null && string.length() > 0 && string.charAt(0) == '#') {
            n = Tools.parseHexInt(string.substring(1));
            selectColor = new Color(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
        }
        string = GlobalConfig.getS("Common.color.objects");
        if (Global.DEBUG > 0) {
            System.out.println("Common.color.objects=" + string);
        }
        if (string != null && string.length() > 0 && string.charAt(0) == '#') {
            n = Tools.parseHexInt(string.substring(1));
            objectsColor = new Color(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
        }
    }

    public static boolean isMac() {
        return Platform.isMac;
    }

    public static boolean isPopupTrigger(MouseEvent mouseEvent) {
        return Platform.isMac ? mouseEvent.isControlDown() && !mouseEvent.isShiftDown() && !mouseEvent.isAltDown() && !mouseEvent.isMetaDown() : mouseEvent.isPopupTrigger();
    }

    public static boolean isZoomTrigger(MouseEvent mouseEvent) {
        return Platform.isMac ? mouseEvent.getButton() == 1 && mouseEvent.isMetaDown() || mouseEvent.getButton() == 2 : mouseEvent.getButton() == 2 || mouseEvent.isMetaDown();
    }

    public static boolean isQueryTrigger(MouseEvent mouseEvent) {
        return mouseEvent.isControlDown() && !mouseEvent.isAltDown();
    }

    public static boolean isMoveTrigger(MouseEvent mouseEvent) {
        return Platform.isMac ? mouseEvent.isAltDown() && mouseEvent.getButton() == 1 || mouseEvent.getButton() == 3 : mouseEvent.isAltDown() && !mouseEvent.isControlDown() && !mouseEvent.isShiftDown() && mouseEvent.getButton() == 1;
    }

    public static boolean isExtQuery(MouseEvent mouseEvent) {
        return mouseEvent.isShiftDown() && mouseEvent.isControlDown();
    }

    public static boolean isSelectTrigger(MouseEvent mouseEvent) {
        return Platform.isMac ? (mouseEvent.getModifiers() & 0x10) == 16 && (mouseEvent.isShiftDown() || !mouseEvent.isControlDown() && !mouseEvent.isAltDown() && !mouseEvent.isMetaDown()) : !mouseEvent.isAltDown() && !mouseEvent.isMetaDown() && (!mouseEvent.isControlDown() || mouseEvent.isShiftDown()) && (mouseEvent.getModifiers() & 4) != 4 && (mouseEvent.getModifiers() & 8) != 8 && (mouseEvent.getModifiers() & 0x10) == 16;
    }

    public static int getSelectMode(MouseEvent mouseEvent) {
        return mouseEvent.isShiftDown() ? (mouseEvent.isControlDown() || mouseEvent.isAltDown() ? 2 : 1) : 0;
    }

    public static void printEvent(MouseEvent mouseEvent) {
        if (Global.DEBUG > 0) {
            String string = "";
            if (mouseEvent.isShiftDown()) {
                string = string + " SHIFT";
            }
            if (mouseEvent.isAltDown()) {
                string = string + " ALT";
            }
            if (mouseEvent.isControlDown()) {
                string = string + " CTRL";
            }
            if (mouseEvent.isMetaDown()) {
                string = string + " META";
            }
            if (mouseEvent.isAltGraphDown()) {
                string = string + " ALT.GR";
            }
            if ((mouseEvent.getModifiers() & 0x10) == 16) {
                string = string + " M1";
            }
            if ((mouseEvent.getModifiers() & 8) == 8) {
                string = string + " M2";
            }
            if ((mouseEvent.getModifiers() & 4) == 4) {
                string = string + " M3";
            }
            if (mouseEvent.isPopupTrigger()) {
                string = string + " POPUP";
            }
            System.out.println("Event:" + mouseEvent + string);
        }
    }

    public static void addWarning(String string) {
        if (maxWarnings > 0 && warningsCount == maxWarnings) {
            warnings.append("** Too many warnings. No further warnings will be recoreded. **");
            ++warningsCount;
        }
        if (maxWarnings > 0 && warningsCount > maxWarnings) {
            return;
        }
        if (warnings == null) {
            warnings = new StringBuffer(string);
        } else {
            warnings.append(string);
        }
        warnings.append("\n");
        ++warningsCount;
    }

    public static String getWarnings() {
        return warnings == null ? null : warnings.toString();
    }

    public static void flushWarnings() {
        warnings = null;
        warningsCount = 0;
    }

    public static String getTriGraph(String string) {
        char c;
        int n;
        if (string.length() < 4) {
            return string;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = true;
        StringBuffer stringBuffer = new StringBuffer("");
        StringBuffer stringBuffer2 = new StringBuffer("");
        for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            if (c >= 'A' && c <= 'Z') {
                ++n2;
                stringBuffer.append(c);
            }
            if (c > '0' && c <= '9') {
                bl2 = false;
            }
            if (!bl2 && c >= '0' && c <= '9') {
                ++n3;
                stringBuffer2.append(c);
            }
            if (c != '0' || !bl2) continue;
            ++n4;
        }
        if (n3 == 1) {
            n3 = 2;
            stringBuffer2 = new StringBuffer("0" + stringBuffer2.toString());
        }
        c = string.charAt(string.length() - 1);
        if (n3 > 0) {
            if (n3 < 3 && string.length() > 4 && string.charAt(1) == '_' && string.charAt(2) == 'i' && string.charAt(3) == '_') {
                return string.charAt(0) + "i" + stringBuffer2.toString();
            }
            if (n2 + n3 < 5 && n2 > 0) {
                return stringBuffer.toString() + stringBuffer2.toString();
            }
            if (n3 < 4 && n2 > 0) {
                return stringBuffer.toString().substring(0, 4 - n3) + stringBuffer2.toString();
            }
            if (n3 > 1 && n3 < 4 && n2 == 0 && string.charAt(0) > '9') {
                return string.charAt(0) + stringBuffer2.toString();
            }
            if (n3 == 1 && string.charAt(0) > '9' && string.charAt(string.length() - 1) > '9') {
                return string.charAt(0) + stringBuffer2.toString() + string.charAt(string.length() - 1);
            }
            if (n3 == 1 && string.charAt(0) > '9') {
                c = stringBuffer2.toString().charAt(0);
            }
        }
        if (n2 == 3 || n2 == 4) {
            return stringBuffer.toString();
        }
        if (n2 == 2 && (c < 'A' || c > 'Z')) {
            return stringBuffer.append(c).toString();
        }
        char c2 = ' ';
        String string2 = "aeiouAEIOU ._\t\n\r\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd";
        for (n = 1; n < string.length() - 1; ++n) {
            char c3 = string.charAt(n);
            if (string2.indexOf(c3) != -1) continue;
            c2 = c3;
            break;
        }
        if (c2 == ' ') {
            c2 = string.charAt(1);
        }
        return "" + string.charAt(0) + c2 + c;
    }

    public static Dimension getScreenRes() {
        if (screenRes == null) {
            screenRes = Toolkit.getDefaultToolkit().getScreenSize();
        }
        return screenRes;
    }

    public static void beginWorking(String string) {
        if (workFrame != null) {
            Common.endWorking();
        }
        workFrame = new Frame();
        workFrame.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void endWorking() {
        if (workFrame != null) {
            workFrame.dispose();
            workFrame = null;
        }
    }

    public static double gammaAdjust(double d) {
        return d > 0.00304 ? 1.055 * Math.pow(d, 1.0 / displayGamma) - 0.055 : 12.92 * d;
    }

    public static Color getHCLcolor(double d, double d2, double d3) {
        double d4 = 95.047;
        double d5 = 100.0;
        double d6 = 108.883;
        double d7 = d4 + d5 + d6;
        double d8 = d4 / d7;
        double d9 = d5 / d7;
        double d10 = 2.0 * d8 / (6.0 * d9 - d8 + 1.5);
        double d11 = 4.5 * d9 / (6.0 * d9 - d8 + 1.5);
        double d12 = d2 * Math.cos(Math.PI / 180 * d);
        double d13 = d2 * Math.sin(Math.PI / 180 * d);
        double d14 = d5 * (d3 > 7.999592 ? Math.pow((d3 + 16.0) / 116.0, 3.0) : d3 / 903.3);
        double d15 = d12 / (13.0 * d3) + d10;
        double d16 = d13 / (13.0 * d3) + d11;
        double d17 = 9.0 * d14 * d15 / (4.0 * d16);
        double d18 = -d17 / 3.0 - 5.0 * d14 + 3.0 * d14 / d16;
        int n = (int)(255.0 * Common.gammaAdjust((3.240479 * d17 - 1.53715 * d14 - 0.498535 * d18) / d5));
        int n2 = (int)(255.0 * Common.gammaAdjust((-0.969256 * d17 + 1.875992 * d14 + 0.041556 * d18) / d5));
        int n3 = (int)(255.0 * Common.gammaAdjust((0.055648 * d17 - 0.204043 * d14 + 1.057311 * d18) / d5));
        if (n < 0) {
            n = 0;
        }
        if (n > 255) {
            n = 255;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        return new Color(n, n2, n3);
    }

    public static Color getHCLcolor(double d) {
        return Common.getHCLcolor(d, 35.0, 85.0);
    }

    public static Color getHCLcolor(double d, double d2) {
        return Common.getHCLcolor(d, d2, 85.0);
    }

    static {
        defWinListener = null;
        displayGamma = 2.2;
    }
}

