% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_iota}
\alias{plot_iota}
\title{Plot Iota2}
\usage{
plot_iota(
  object,
  xlab = "Amount on all cases",
  ylab = "Categories",
  liota = "Assignment of the true category (Iota)",
  lcase2 = "Assignment to the false category",
  lcase3 = "Assignment from the false true category",
  lscale_quality = "Scale Quality",
  lscale_cat = c("insufficent", "minimum", "satisfactory", "good", "excellent"),
  number_size = 6,
  key_size = 0.5,
  text_size = 10,
  scale = "none"
)
}
\arguments{
\item{object}{Estimates of Iota 2 created with \code{compute_iota2()},
\code{check_dgf()} or \code{check_new_rater()}.}

\item{xlab}{\code{Character} passed to xlab() from scale_fill_manual(). Label
of the x-axis.}

\item{ylab}{\code{Character} passed to ylab() from scale_fill_manual(). Label
of the y-axis.}

\item{liota}{\code{Character} passed to labels() from scale_fill_manual().
Label for Iota.Amount of cases that are assigned to the correct category.}

\item{lcase2}{\code{Character} passed to labels() from scale_fill_manual().
Label for the amount of cases that are assigned to a false category.}

\item{lcase3}{\code{Character} passed to labels() from scale_fill_manual().
Label for the amount of cases that are assigned from a false category.}

\item{lscale_quality}{\code{character} passed to scale_fill_manual() determining
the title for the quality of a scale. Only used in conjunction with
\code{scale}.}

\item{lscale_cat}{Vector of strings with length 5. This vector contains the
labels for each category of quality for the scale.}

\item{number_size}{\code{Double} passed to geom_text() determining the size
of the numbers within the plot.}

\item{key_size}{\code{Double} passed to theme() determining the size of the
legend keys.}

\item{text_size}{\code{Double} passed to theme() determining the size of the
text within the legend.}

\item{scale}{\code{String} for requesting an additional plot of reliability
on the scale level. If \code{scale="dynamic_iota_index"} Dynamic Iota Index
is used.  If \code{scale="static_iota_index"} Static Iota Index
is used. If \code{scale="none"} no additional plot is created.}
}
\value{
Function returns an object of class \code{gg, ggplot} illustrating how
the data of the different categories influence each other.
}
\description{
Function for creating a plot object that can be plotted via \link{ggplot2}.
}
\note{
An example for interpreting the plot can be found in the vignette
\href{../iotarelr.html}{Get started} or via
\code{vignette("iotarelr", package = "iotarelr")}.
}
\references{
Florian Berding and Julia Pargmann (2022).Iota Reliability Concept
of the Second Generation. Measures for Content Analysis Done by
Humans or Artificial Intelligences. Berlin: Logos.
https://doi.org/10.30819/5581
}
