% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equation_solve.R
\name{equation_solve}
\alias{equation_solve}
\title{Solve a basic (matrix) equation}
\usage{
equation_solve(LHS = NULL, Im = NULL)
}
\arguments{
\item{LHS}{A left-hand side vector with a key column containing the 
industry or product names for matching, for example the employment coefficients.}

\item{Im}{A Leontieff-inverse with a key column containing the industry or 
product names for matching.}
}
\value{
A data.frame with auxiliary metadata to conform the symmetric
input-output tables.
}
\description{
The function matches to parts of the matrix equation, using the named
formats with row names and solves the matrix equation.
}
\details{
This function is used in wrapper functions, such as \code{\link{multiplier_create}}.
to solve particular problems, but it can be used directly, too.
The function only performs the lhs %*% im matrix equation, but after 
pairing industries and checking for exceptions.
}
\examples{
Im = data.frame (
a = c("row1", "row2"), 
b = c(1,1), 
c = c(2,0))
LHS = data.frame (
a = "lhs", 
b = 1, 
c = 0.5)
equation_solve (Im = Im, LHS = LHS)
}
