% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ivLT.R
\name{iv.opC}
\alias{iv.BrC}
\alias{iv.opC}
\alias{iv.opChalf}
\title{Inverse Laplace Transform}
\usage{
iv.opC(L.FUN, t, nterms = 31L, m = 1, fail.val = NA)

iv.opChalf(L.FUN, t, nterms = 16L, m = 1, fail.val = NA)

iv.BrC(L.FUN, t, nterms = 1000L, gamma = 1)
}
\arguments{
\item{L.FUN}{the Laplace-Transformed function}

\item{t}{standard (time) domain function at which to evaluate}

\item{nterms}{number of terms to use in the numerical inversion (odd number safest for \code{iv.opC}, even for \code{iv.opChalf})}

\item{m}{see \code{\link{opC.r}} documentation}

\item{fail.val}{value to return in event of failure to converge}

\item{gamma}{the Bromwich contour is a straight line and intersects the real axis at \eqn{\gamma}}
}
\description{
Functionals that numerically invert a Laplace Transform.
}
\details{
Optimum contour based on:

Evans & Chung, 2000: Laplace transform inversions using optimal contours in the complex plane \emph{International Journal of Computer Mathematics} v73 pp531-543.
}
\section{Functions}{
\itemize{
\item \code{iv.opC}: inversion using the full optimum contour

\item \code{iv.opChalf}: for functions which are symmetric about the real axis, it is sufficient to use half the optimum contour and half the number of subdivisions (\code{nterms})

\item \code{iv.BrC}: inversion using the Bromwich contour (the definition, but very unstable for numerical evaluation - not recommended)
}}
\examples{
tvals <- seq(-pi/2, pi/2, length.out = 7)
sinvals <- vapply(tvals, iv.opC, complex(1), L.FUN = L.sin)
plot(tvals, Re(sinvals), type = "l")
}

