% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fieldbook_report.R
\name{fieldbook_report}
\alias{fieldbook_report}
\title{Fieldbook report}
\usage{
fieldbook_report(
  data,
  fb_smr,
  variable,
  model_facts,
  dotplot_groups = NULL,
  model_diag = FALSE
)
}
\arguments{
\item{data}{Field book data.}

\item{fb_smr}{Summary of the variables in the fieldbook.}

\item{variable}{Response variable.}

\item{model_facts}{Model used for the experimental design.}

\item{dotplot_groups}{Factors to compare. See details.}

\item{model_diag}{Diagnostic for model (default = FALSE).}
}
\value{
data frame
}
\description{
Function to create a complete report of the fieldbook
}
\details{
For compare the factors you should use "*". For example, to compare
treatment1 and treatment2: \code{treatment1*treatment2}.
}
\examples{

library(inti)
library(googlesheets4)

if (gs4_has_token()) {

url <- paste0("https://docs.google.com/spreadsheets/d/"
              , "15r7ZwcZZHbEgltlF6gSFvCTFA-CFzVBWwg3mFlRyKPs/edit#gid=172957346")
# browseURL(url)
gs <- as_sheets_id(url)

(data <- gs \%>\%
    range_read("fb"))

(fb_smr <- gs \%>\%
  range_read("fbsm"))

report <- fieldbook_report(data
                          , fb_smr = fb_smr
                          , variable = "LA"
                          , dotplot_groups = "genotype"
                          , model_diag = TRUE
                          )
report

}

}
