% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iproto.R
\name{iproto}
\alias{iproto}
\title{Generate a zero length dataframe conforming to an \code{iface} specification}
\usage{
iproto(iface)
}
\arguments{
\item{iface}{the specification}
}
\value{
a dataframe conforming to \code{iface}
}
\description{
This function is used internally for default values for a dataframe
parameter. It generates a zero length dataframe that conforms to a \code{iface}
specification, in terms of column names, data types and groupings. Such a
dataframe is not guaranteed to be fully conformant to the \code{iface}
specification if, for example, completeness constraints are applied.
}
\examples{
i = interfacer::iface(
  col1 = integer ~ "A number",
  col2 = character ~ "A string"
)

iproto(i)
}
\concept{interface}
