% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interacCircos.R
\name{CircosLegend}
\alias{CircosLegend}
\title{Create a LEGEND module to a moduleList}
\usage{
CircosLegend(
  modulename,
  x = 20,
  y = 20,
  title = "legend",
  size = 6,
  weight = "normal",
  GapBetweenGraphicText = 5,
  GapBetweenLines = 20,
  data,
  ...
)
}
\arguments{
\item{modulename}{The name of the new module.}

\item{x, y}{Coordinates of the lower left corner of the annotation}

\item{title}{The title for legend}

\item{size}{Font size for title, with units specified (such as em or px).}

\item{weight}{Font weight for title. Can be "normal", "bold", "bolder" or "lighter".}

\item{GapBetweenGraphicText}{Gap between icon and text in legend.}

\item{GapBetweenLines}{Gap between each two lines in legend}

\item{data}{A list of legend with details including type, color, opacity, circleSize, rectSize, lineWidth,
lineHeight, text, textSize and textWeight. Details can be found on document.}

\item{...}{Ignored}
}
\value{
The module tracks for legend modules.
}
\description{
Simple legend annotation displayed in the visualization.
}
\examples{
legend1 <- list(type= "circle", color="#1E77B4",opacity="1.0",circleSize="8",text= "C.CK", 
textSize= "14",textWeight="normal")
legend2 <- list(type= "circle", color="#AEC7E8",opacity="1.0",circleSize="8",text= "C.NPK", 
textSize= "14",textWeight="normal")
Circos(CircosLegend('legend01', title = "legend",data=list(legend1,legend2),size = 20))

}
