% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_checks.R
\name{col_check}
\alias{col_check}
\title{Check a single column for data fidelity.}
\usage{
col_check(colname, data, fun, output = FALSE, stage = NULL, ...)
}
\arguments{
\item{colname}{character string specifying the name of the column within your
dataframe.}

\item{data}{the dataframe containing the data.}

\item{fun}{the check function you'd like to apply to the data.}

\item{output}{logical. If FALSE, the function returns a dataframe containing
only records that failed the specified check. If TRUE, invisibly prints an
excel output file containing only the records that failed the specified
check.}

\item{stage}{An optional character string that can be used to specify the
stage of the checking process in which the check is occurring. Only useful
if output = TRUE. If a value is specified, a that value is prefixed to the
output file; if no value is given, no stage prefix is attached.}

\item{...}{arguments to be passed through to the function specified in
\code{fun}}
}
\value{
col_check(output = FALSE) returns a dataframe containing only records
  that failed the specified check.

col_check(output = TRUE) invisibly prints an excel output file
  containing only records that failed the specified check.
}
\description{
Check a single column for data fidelity.
}
\examples{
col_check(colname = "ID_var", data = dataset, fun = numeric_check,
output = TRUE, stage = "1-Reasonableness")

col_check(colname = "FName", data = dataset, fun = character_check,
output = FALSE)

}

