% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_algorithm.R
\name{find_algorithm}
\alias{find_algorithm}
\title{Find sampling algorithm and optimizers}
\usage{
find_algorithm(x, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{...}{Currently not used.}
}
\value{
A list with elements depending on the model.
  \cr
  For frequentist models:
   \itemize{
     \item \code{algorithm}, for instance \code{"OLS"} or \code{"ML"}
     \item \code{optimizer}, name of optimizing function, only applies to specific models (like \code{gam})
   }
  For frequentist mixed models:
   \itemize{
     \item \code{algorithm}, for instance \code{"REML"} or \code{"ML"}
     \item \code{optimizer}, name of optimizing function
   }
  For Bayesian models:
   \itemize{
     \item \code{algorithm}, the algorithm
     \item \code{chains}, number of chains
     \item \code{iterations}, number of iterations per chain
     \item \code{warmup}, number of warmups per chain
   }
}
\description{
Returns information on the sampling or estimation algorithm
  as well as optimization functions, or for Bayesian model information on
  chains, iterations and warmup-samples.
}
\examples{
library(lme4)
data(sleepstudy)
m <- lmer(Reaction ~ Days + (1 | Subject), data = sleepstudy)
find_algorithm(m)

\dontrun{
library(rstanarm)
m <- stan_lmer(Reaction ~ Days + (1 | Subject), data = sleepstudy)
find_algorithm(m)}

}
