% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_insee_dataset}
\alias{get_insee_dataset}
\title{Get dataset from INSEE BDM database}
\usage{
get_insee_dataset(
  dataset,
  startPeriod = NULL,
  endPeriod = NULL,
  firstNObservations = NULL,
  lastNObservations = NULL,
  filter = NULL
)
}
\arguments{
\item{dataset}{dataset name to be downloaded}

\item{startPeriod}{start date of data}

\item{endPeriod}{end date of data}

\item{firstNObservations}{get the first N observations for each key series (idbank)}

\item{lastNObservations}{get the last N observations for each key series (idbank)}

\item{filter}{Use the filter to choose only some dimensions. It is recommended to use it for big datasets.
A dimension left empty means all values are selected. To select multiple values in one dimension put a "+" between those values (see example)}
}
\description{
Get dataset from INSEE BDM database
}
\details{
Get dataset from INSEE BDM database
}
\examples{
data = get_insee_dataset("IPC-2015", filter = "M+A.........CVS.", lastNObservations = 1)

}
