% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotCrossSection.R
\name{PlotCrossSection}
\alias{PlotCrossSection}
\title{Plot Cross Section}
\usage{
PlotCrossSection(
  transect,
  rs,
  geo.lays = names(rs),
  val.lays = NULL,
  wt.lay = NULL,
  asp = 1,
  ylim = NULL,
  max.dev.dim = c(43, 56),
  n = NULL,
  breaks = NULL,
  pal = NULL,
  col = NULL,
  ylab = NULL,
  unit = NULL,
  id = c("A", "A'"),
  labels = NULL,
  explanation = NULL,
  features = NULL,
  max.feature.dist = Inf,
  draw.key = TRUE,
  draw.sep = TRUE,
  is.categorical = FALSE,
  contour.lines = NULL,
  bg.col = NULL,
  wt.col = "#FFFFFFD8",
  bend.label = "BEND",
  scale.loc = NULL,
  file = NULL
)
}
\arguments{
\item{transect}{'SpatialLines'.
Piecewise linear transect line.}

\item{rs}{'RasterStack' or 'RasterBrick'.
Collection of raster layers with the same extent and resolution.}

\item{geo.lays}{'character' vector.
Names in \code{rs} that specify the geometry-raster layers;
these must be given in decreasing order, that is,
from the upper most (such as land surface) to the lowest (such as a bedrock surface).}

\item{val.lays}{'character' vector.
Names in \code{rs} that specify the value-raster layers (optional).
Values from the first layer are mapped as colors to
the area between the first and second geometry layers;
the second layer mapped between the second and third geometry layers, and so on.}

\item{wt.lay}{'character' string.
Name in \code{rs} that specifies the water-table-raster layer (optional).}

\item{asp}{'numeric' number.
\emph{y/x} aspect ratio for spatial axes.
Defaults to 1 (one unit on the \emph{x}-axis equals one unit on the \emph{y}-axis) when \code{r} is projected,
otherwise, a calculated value based on axes limits is used.}

\item{ylim}{'numeric' vector of length 2.
Minimum and maximum values for the \emph{y}-axis.}

\item{max.dev.dim}{'numeric' vector of length 2, value is recycled as necessary.
Maximum width and height for the graphics device in picas, respectively.
Where 1 pica is equal to 1/6 of an inch, 4.2333 of a millimeter, or 12 points.
Suggested dimensions for single-column, double-column, and side title figures are
\code{c(21, 56)}, \code{c(43, 56)}, and \code{c(56, 43)}, respectively.
This argument is only applicable when the \code{file} argument is specified.}

\item{n}{'integer' count.
Desired number of intervals to partition the range of raster values (optional).}

\item{breaks}{'numeric' vector.
Break points used to partition the colors representing numeric raster values (optional).}

\item{pal}{'function'.
Color palette to be used to assign colors in the plot.}

\item{col}{'character' vector.
Colors to be used in the plot.
This argument requires \code{breaks} specification for numeric raster values
and overrides any palette function specification.
For numeric values there should be one less color than breaks.
Categorical data require a color for each category.}

\item{ylab}{'character' string.
Label for the \emph{y} axis.}

\item{unit}{'character' string.
Label for the measurement unit of the \emph{x}- and \emph{y}-axes.}

\item{id}{'character' vector of length 2.
Labels for the end points of the transect line, defaults to \emph{A--A'}.}

\item{labels}{'list'.
Location and values of labels in the color key.
This list may include components \code{at} and \code{labels}.}

\item{explanation}{'character' string.
Label explaining the raster cell value.}

\item{features}{'SpatialPointsDataFrame'.
Point features adjacent to the transect line that are used
as reference labels for the upper geometry layer.
Labels taken from first column of embedded data table.}

\item{max.feature.dist}{'numeric' number.
Maximum distance from a point feature to the transect line,
specified in the units of the \code{rs} projection.}

\item{draw.key}{'logical' flag.
Whether a color key should be drawn.}

\item{draw.sep}{'logical' flag.
Whether lines separating geometry layers are drawn.}

\item{is.categorical}{'logical' flag.
If true, cell values in \code{val.lays} represent categorical data;
otherwise, these data values are assumed continuous.}

\item{contour.lines}{'list'.
If specified, contour lines are drawn.
The contours are described using a list of arguments supplied to the \code{\link[raster]{contour}} function.
Passed arguments include \code{drawlables}, \code{method}, and \code{col}.}

\item{bg.col}{'character' string.
Color used for the background of the area below the top geometry-raster layer.}

\item{wt.col}{'character' string.
Color used for the water-table line.}

\item{bend.label}{'character' vector.
Labels to place at top of the bend-in-section lines,
values are recycled as necessary to the number of bends.}

\item{scale.loc}{'character' string.
Position of the scale bar in the main plot region;
see \code{\link{GetInsetLocation}} function for keyword descriptions.}

\item{file}{'character' string.
Name of the output file.
Specifying this argument will start a graphics device driver for producing a
PDF or PNG file format---the file extension determines the format type.
The width and height of the graphics region will be automagically determined and
included with the function's returned values, see "Value" section for details;
these device dimensions can be useful when creating similar map layouts in dynamic reports.}
}
\value{
A 'list' with the following graphical parameters:
  \describe{
    \item{din}{device dimensions \code{(width, height)}, in inches.}
    \item{usr}{extremes of the coordinates of the plotting region \code{(x1, x2, y1, y2)}.}
    \item{heights}{relative heights on the device \code{(upper, lower)}
      for the map and color-key plots.}
  }
}
\description{
Draw a cross-section view of raster data.
A key showing how the colors map to raster values is shown below the map.
The width and height of the graphics region will be automagically determined in some cases.
}
\examples{
m <- datasets::volcano
m <- m[nrow(m):1, ncol(m):1]
x <- seq(from = 2667405, length.out = ncol(m), by = 10)
y <- seq(from = 6478705, length.out = nrow(m), by = 10)
r1 <- raster::raster(m, xmn = min(x), xmx = max(x), ymn = min(y),
                     ymx = max(y), crs = "+init=epsg:27200")
r2 <- min(r1[]) - r1 / 10
r3 <- r1 - r2
rs <- raster::stack(r1, r2, r3)
names(rs) <- c("r1", "r2", "r3")
xy <- rbind(c(2667508, 6479501),
            c(2667803, 6479214),
            c(2667508, 6478749))
transect <- sp::Lines(list(sp::Line(xy)), ID = "Transect")
transect <- sp::SpatialLines(list(transect),
                             proj4string = raster::crs(rs))
xy <- rbind(c(2667705, 6478897),
            c(2667430, 6479178))
p <- sp::SpatialPoints(xy, proj4string = raster::crs(rs))
d <-  data.frame("label" = c("Peak", "Random"), stringsAsFactors = TRUE)
features <- sp::SpatialPointsDataFrame(p, d, match.ID = TRUE)
bg.image <- raster::hillShade(raster::terrain(r1, "slope"),
                              raster::terrain(r1, "aspect"))
PlotMap(r1, bg.image = bg.image,
        pal = GetColors(scheme = "DEM screen", alpha = 0.8),
        scale.loc = "top", arrow.loc = "topright",
        contour.lines = list("col" = "#1F1F1FA6"),
        useRaster = TRUE)
lines(transect)
raster::text(as(transect, "SpatialPoints"),
             labels = c("A", "BEND", "A'"),
             halo = TRUE, cex = 0.7, pos = c(3, 4, 1),
             offset = 0.1, font = 4)
points(features, pch = 19)
raster::text(features, labels = features@data$label, halo = TRUE,
             cex = 0.7, pos = 4, offset = 0.5, font = 4)

dev.new()
asp <- 5
unit <- "METERS"
explanation <- "Vertical thickness between layers, in meters."
PlotCrossSection(transect, rs, geo.lays = c("r1", "r2"),
                 val.lays = "r3", ylab = "Elevation", asp = asp,
                 unit = unit, explanation = explanation,
                 features = features, max.feature.dist = 100,
                 bg.col = "#E1E1E1", bend.label = "BEND IN\nSECTION",
                 scale.loc = NULL)
AddScaleBar(unit = unit, vert.exag = asp, inset = 0.05)

val <- PlotCrossSection(transect, rs, geo.lays = c("r1", "r2"),
                        val.lays = "r3", ylab = "Elevation", asp = 5,
                        unit = "METERS", explanation = explanation,
                        file = "Rplots.png")
print(val)

graphics.off()
file.remove("Rplots.png")

}
\seealso{
\code{\link{AddScaleBar}}, \code{\link{AddColorKey}},
  \code{\link{ExtractAlongTransect}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{hplot}
