% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExportRasterStack.R
\name{ExportRasterStack}
\alias{ExportRasterStack}
\title{Export a Raster Stack}
\usage{
ExportRasterStack(rs, path, zip = "", col = NULL)
}
\arguments{
\item{rs}{'RasterStack' or 'RasterBrick'.
Collection of \code{\linkS4class{RasterLayer}} objects with
the same extent and resolution.}

\item{path}{'character' string.
Path name to write raster stack.}

\item{zip}{'character' string.
If there is no zip program on your path (on windows),
you can supply the full path to a \file{zip.exe} here, in order to make a KMZ file.}

\item{col}{'character' vector.
Color names}
}
\value{
Used for the side-effect files written to disk.
}
\description{
Write a raster-stack, a collection of raster layers,
to local directories using multiple file formats.
}
\details{
Five local directories are created under \code{path} and
  named after their intended file formats:
  Comma-Separated Values (\file{csv}),
  Portable Network Graphics (\file{png}),
  Georeferenced TIFF (\file{tif}),
  R Data (\file{rda}), and
  Keyhole Markup Language (\file{kml}).
  For its reference system, \file{kml} uses geographic coordinates:
  longitude and latitude components as defined by the World Geodetic System of 1984.
  Therefore, the conversion of gridded data between cartographic projections
  may introduce a new source of error.
}
\note{
If the zip program is unavailable on windows, install it
  by downloading the latest binary version from the
  \href{https://www.7-zip.org/download.html}{Info-ZIP} website;
  select one of the given FTP locations, enter directory \file{win32},
  download \file{zip300xn.zip}, and extract.
}
\examples{
\dontrun{
rs <- raster::stack(system.file("external/rlogo.grd", package = "raster"))
print(rs)
path <- file.path(tempdir(), "rlogo")
dir.create(path)
ExportRasterStack(rs, path)
list.files(normalizePath(path, winslash = "/"), full.name = TRUE,
           recursive = TRUE, include.dirs = TRUE)

unlink(path, recursive = TRUE)
}

}
\seealso{
\code{\link[raster]{writeRaster}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{IO}
