% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddGradientLegend.R
\name{AddGradientLegend}
\alias{AddGradientLegend}
\title{Add Color Gradient Legend to Plot}
\usage{
AddGradientLegend(breaks, pal, at = NULL, n = 5L, labels = TRUE,
  scientific = FALSE, title = NULL, loc = c("bottomleft", "topleft",
  "topright", "bottomright"), inset = 0, strip.dim = c(2, 8))
}
\arguments{
\item{breaks}{'numeric'.
Set of finite numeric breakpoints for the colors.}

\item{pal}{'function'.
Color palette}

\item{at}{'numeric'.
Vector of points at which tick-marks and labels are to be drawn.}

\item{n}{'integer'.
Desired number of tick-marks to be drawn.
Unused if \code{at} argument is specified.}

\item{labels}{'logical' or 'character'.
Can either be a logical value specifying whether (numerical) annotations are to be made at the tickmarks,
or a character or expression vector of labels to be placed at the tickpoints.}

\item{scientific}{'logical'.
Indicates if labels should be formatted for scientific notation,
see \code{\link{ToScientific}} for details.}

\item{title}{'character'.
Title to be placed at the top of the legend.}

\item{loc}{'character'.
Position of the legend in the main plot region:
"bottomleft", "topleft", "topright", or "bottomright" to denote legend location.}

\item{inset}{'numeric'.
Inset distance(s) from the margins as a fraction of the plot region.}

\item{strip.dim}{'numeric'.
Dimensions of the color strip, in picas.}
}
\value{
Used for the side-effect of a legend drawn on the current graphics device.
}
\description{
This function can be used to add a continuous color gradient legend strip to a plot.
}
\examples{
plot(NA, xlim = c(0, 100), ylim = c(-10, 10), xlab = "", ylab = "")
breaks <- 0:200
AddGradientLegend(breaks, rainbow, title = "Title")
AddGradientLegend(breaks, rainbow, title = "Title", inset = c(0.2, 0.1))
breaks <- seq(0, 2e+06, length.out = 5)
AddGradientLegend(breaks, rainbow, loc = "topright", inset = 0.1)
pal <- function(...) rev(rainbow(...))  # reverse colors in palette
AddGradientLegend(breaks, pal, loc = "bottomright", inset = c(0.2, 0.1),
                  scientific = TRUE, strip.dim = c(1, 14))

}
\seealso{
\code{\link{PlotMap}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{hplot}
