% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{bru_mapper_mesh_B}
\alias{bru_mapper_mesh_B}
\alias{ibm_n.bru_mapper_mesh_B}
\alias{ibm_values.bru_mapper_mesh_B}
\alias{ibm_jacobian.bru_mapper_mesh_B}
\title{Mapper for basis conversion}
\usage{
bru_mapper_mesh_B(mesh, B)

\method{ibm_n}{bru_mapper_mesh_B}(mapper, ...)

\method{ibm_values}{bru_mapper_mesh_B}(mapper, ...)

\method{ibm_jacobian}{bru_mapper_mesh_B}(mapper, input, ...)
}
\arguments{
\item{mesh}{object supported by \code{bru_mapper}, typically \code{fm_mesh_2d} or
\code{fm_mesh_1d}}

\item{B}{a square or tall basis conversion matrix}

\item{mapper}{A mapper S3 object, inheriting from \code{bru_mapper}.}

\item{...}{Arguments passed on to other methods}

\item{input}{The values for which to produce a mapping matrix}
}
\description{
Creates a mapper for handling basis conversions
}
\seealso{
\link{bru_mapper}, \link{bru_mapper_generics}

Other mappers: 
\code{\link{bru_get_mapper}()},
\code{\link{bru_mapper}()},
\code{\link{bru_mapper.fm_mesh_1d}()},
\code{\link{bru_mapper.fm_mesh_2d}()},
\code{\link{bru_mapper_aggregate}()},
\code{\link{bru_mapper_collect}()},
\code{\link{bru_mapper_const}()},
\code{\link{bru_mapper_factor}()},
\code{\link{bru_mapper_generics}},
\code{\link{bru_mapper_harmonics}()},
\code{\link{bru_mapper_index}()},
\code{\link{bru_mapper_linear}()},
\code{\link{bru_mapper_logsumexp}()},
\code{\link{bru_mapper_marginal}()},
\code{\link{bru_mapper_matrix}()},
\code{\link{bru_mapper_multi}()},
\code{\link{bru_mapper_pipe}()},
\code{\link{bru_mapper_scale}()},
\code{\link{bru_mapper_shift}()},
\code{\link{bru_mapper_taylor}()}
}
\concept{mappers}
